<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApiSourceApplication StructType
 * @subpackage Structs
 */
class ApiSourceApplication extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * The Subcategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subcategory;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Version;
    /**
     * Constructor method for ApiSourceApplication
     * @uses ApiSourceApplication::setName()
     * @uses ApiSourceApplication::setCategory()
     * @uses ApiSourceApplication::setSubcategory()
     * @uses ApiSourceApplication::setVersion()
     * @param string $name
     * @param string $category
     * @param string $subcategory
     * @param string $version
     */
    public function __construct($name = null, $category = null, $subcategory = null, $version = null)
    {
        $this
            ->setName($name)
            ->setCategory($category)
            ->setSubcategory($subcategory)
            ->setVersion($version);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ApiSourceApplication
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\ApiSourceApplication
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Subcategory value
     * @return string|null
     */
    public function getSubcategory()
    {
        return $this->Subcategory;
    }
    /**
     * Set Subcategory value
     * @param string $subcategory
     * @return \StructType\ApiSourceApplication
     */
    public function setSubcategory($subcategory = null)
    {
        // validation for constraint: string
        if (!is_null($subcategory) && !is_string($subcategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcategory, true), gettype($subcategory)), __LINE__);
        }
        $this->Subcategory = $subcategory;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\ApiSourceApplication
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
}
