<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivitySearchByFieldInPeriod StructType
 * @subpackage Structs
 */
class ActivitySearchByFieldInPeriod extends AbstractStructBase
{
    /**
     * The activityEntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $activityEntityTypeId;
    /**
     * The dateFieldId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $dateFieldId;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $from;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $to;
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageNumber;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageSize;
    /**
     * The includeFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeFields;
    /**
     * The includeCounters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeCounters;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * Constructor method for ActivitySearchByFieldInPeriod
     * @uses ActivitySearchByFieldInPeriod::setActivityEntityTypeId()
     * @uses ActivitySearchByFieldInPeriod::setDateFieldId()
     * @uses ActivitySearchByFieldInPeriod::setFrom()
     * @uses ActivitySearchByFieldInPeriod::setTo()
     * @uses ActivitySearchByFieldInPeriod::setPageNumber()
     * @uses ActivitySearchByFieldInPeriod::setPageSize()
     * @uses ActivitySearchByFieldInPeriod::setIncludeFields()
     * @uses ActivitySearchByFieldInPeriod::setIncludeCounters()
     * @uses ActivitySearchByFieldInPeriod::setCredentials()
     * @uses ActivitySearchByFieldInPeriod::setFieldValues()
     * @param string $activityEntityTypeId
     * @param string $dateFieldId
     * @param string $from
     * @param string $to
     * @param int $pageNumber
     * @param int $pageSize
     * @param bool $includeFields
     * @param bool $includeCounters
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     */
    public function __construct($activityEntityTypeId = null, $dateFieldId = null, $from = null, $to = null, $pageNumber = null, $pageSize = null, $includeFields = null, $includeCounters = null, \StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this
            ->setActivityEntityTypeId($activityEntityTypeId)
            ->setDateFieldId($dateFieldId)
            ->setFrom($from)
            ->setTo($to)
            ->setPageNumber($pageNumber)
            ->setPageSize($pageSize)
            ->setIncludeFields($includeFields)
            ->setIncludeCounters($includeCounters)
            ->setCredentials($credentials)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get activityEntityTypeId value
     * @return string
     */
    public function getActivityEntityTypeId()
    {
        return $this->activityEntityTypeId;
    }
    /**
     * Set activityEntityTypeId value
     * @param string $activityEntityTypeId
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setActivityEntityTypeId($activityEntityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($activityEntityTypeId) && !is_string($activityEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityEntityTypeId, true), gettype($activityEntityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($activityEntityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $activityEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($activityEntityTypeId, true)), __LINE__);
        }
        $this->activityEntityTypeId = $activityEntityTypeId;
        return $this;
    }
    /**
     * Get dateFieldId value
     * @return string
     */
    public function getDateFieldId()
    {
        return $this->dateFieldId;
    }
    /**
     * Set dateFieldId value
     * @param string $dateFieldId
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setDateFieldId($dateFieldId = null)
    {
        // validation for constraint: string
        if (!is_null($dateFieldId) && !is_string($dateFieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFieldId, true), gettype($dateFieldId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($dateFieldId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $dateFieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($dateFieldId, true)), __LINE__);
        }
        $this->dateFieldId = $dateFieldId;
        return $this;
    }
    /**
     * Get from value
     * @return string
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return string
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param string $to
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
    /**
     * Get pageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param int $pageNumber
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get includeFields value
     * @return bool
     */
    public function getIncludeFields()
    {
        return $this->includeFields;
    }
    /**
     * Set includeFields value
     * @param bool $includeFields
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setIncludeFields($includeFields = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFields) && !is_bool($includeFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFields, true), gettype($includeFields)), __LINE__);
        }
        $this->includeFields = $includeFields;
        return $this;
    }
    /**
     * Get includeCounters value
     * @return bool
     */
    public function getIncludeCounters()
    {
        return $this->includeCounters;
    }
    /**
     * Set includeCounters value
     * @param bool $includeCounters
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setIncludeCounters($includeCounters = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCounters) && !is_bool($includeCounters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCounters, true), gettype($includeCounters)), __LINE__);
        }
        $this->includeCounters = $includeCounters;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\ActivitySearchByFieldInPeriod
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
}
