<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityGetResult StructType
 * @subpackage Structs
 */
class ActivityGetResult extends PvApiResult
{
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityData
     */
    public $Activity;
    /**
     * The Counters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvCounterData
     */
    public $Counters;
    /**
     * Constructor method for ActivityGetResult
     * @uses ActivityGetResult::setActivity()
     * @uses ActivityGetResult::setCounters()
     * @param \StructType\PvActivityData $activity
     * @param \ArrayType\ArrayOfPvCounterData $counters
     */
    public function __construct(\StructType\PvActivityData $activity = null, \ArrayType\ArrayOfPvCounterData $counters = null)
    {
        $this
            ->setActivity($activity)
            ->setCounters($counters);
    }
    /**
     * Get Activity value
     * @return \StructType\PvActivityData|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\PvActivityData $activity
     * @return \StructType\ActivityGetResult
     */
    public function setActivity(\StructType\PvActivityData $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Counters value
     * @return \ArrayType\ArrayOfPvCounterData|null
     */
    public function getCounters()
    {
        return $this->Counters;
    }
    /**
     * Set Counters value
     * @param \ArrayType\ArrayOfPvCounterData $counters
     * @return \StructType\ActivityGetResult
     */
    public function setCounters(\ArrayType\ArrayOfPvCounterData $counters = null)
    {
        $this->Counters = $counters;
        return $this;
    }
}
