<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityAddNoteV3Result StructType
 * @subpackage Structs
 */
class ActivityAddNoteV3Result extends PvApiResult
{
    /**
     * The NoteId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $NoteId;
    /**
     * Constructor method for ActivityAddNoteV3Result
     * @uses ActivityAddNoteV3Result::setNoteId()
     * @param string $noteId
     */
    public function __construct($noteId = null)
    {
        $this
            ->setNoteId($noteId);
    }
    /**
     * Get NoteId value
     * @return string
     */
    public function getNoteId()
    {
        return $this->NoteId;
    }
    /**
     * Set NoteId value
     * @param string $noteId
     * @return \StructType\ActivityAddNoteV3Result
     */
    public function setNoteId($noteId = null)
    {
        // validation for constraint: string
        if (!is_null($noteId) && !is_string($noteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteId, true), gettype($noteId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($noteId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $noteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($noteId, true)), __LINE__);
        }
        $this->NoteId = $noteId;
        return $this;
    }
}
