<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityAddInvolvedResult StructType
 * @subpackage Structs
 */
class ActivityAddInvolvedResult extends PvApiResult
{
    /**
     * The InvolvedId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $InvolvedId;
    /**
     * Constructor method for ActivityAddInvolvedResult
     * @uses ActivityAddInvolvedResult::setInvolvedId()
     * @param string $involvedId
     */
    public function __construct($involvedId = null)
    {
        $this
            ->setInvolvedId($involvedId);
    }
    /**
     * Get InvolvedId value
     * @return string
     */
    public function getInvolvedId()
    {
        return $this->InvolvedId;
    }
    /**
     * Set InvolvedId value
     * @param string $involvedId
     * @return \StructType\ActivityAddInvolvedResult
     */
    public function setInvolvedId($involvedId = null)
    {
        // validation for constraint: string
        if (!is_null($involvedId) && !is_string($involvedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($involvedId, true), gettype($involvedId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($involvedId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $involvedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($involvedId, true)), __LINE__);
        }
        $this->InvolvedId = $involvedId;
        return $this;
    }
}
