<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Role ServiceType
 * @subpackage Services
 */
class Role extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RoleGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RoleGetAll $parameters
     * @return \StructType\RoleGetAllResponse|bool
     */
    public function RoleGetAll(\StructType\RoleGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RoleGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RoleGetObjectRights
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RoleGetObjectRights $parameters
     * @return \StructType\RoleGetObjectRightsResponse|bool
     */
    public function RoleGetObjectRights(\StructType\RoleGetObjectRights $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RoleGetObjectRights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RoleGetAllResponse|\StructType\RoleGetObjectRightsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
