<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Relation ServiceType
 * @subpackage Services
 */
class Relation extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RelationCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationCreate $parameters
     * @return \StructType\RelationCreateResponse|bool
     */
    public function RelationCreate(\StructType\RelationCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationUpdate $parameters
     * @return \StructType\RelationUpdateResponse|bool
     */
    public function RelationUpdate(\StructType\RelationUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationAddAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationAddAttachment $parameters
     * @return \StructType\RelationAddAttachmentResponse|bool
     */
    public function RelationAddAttachment(\StructType\RelationAddAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationAddAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationDeleteAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationDeleteAttachment $parameters
     * @return \StructType\RelationDeleteAttachmentResponse|bool
     */
    public function RelationDeleteAttachment(\StructType\RelationDeleteAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationDeleteAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationAddNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationAddNote $parameters
     * @return \StructType\RelationAddNoteResponse|bool
     */
    public function RelationAddNote(\StructType\RelationAddNote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationAddNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetFields $parameters
     * @return \StructType\RelationGetFieldsResponse|bool
     */
    public function RelationGetFields(\StructType\RelationGetFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationExists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationExists $parameters
     * @return \StructType\RelationExistsResponse|bool
     */
    public function RelationExists(\StructType\RelationExists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationExists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetAll $parameters
     * @return \StructType\RelationGetAllResponse|bool
     */
    public function RelationGetAll(\StructType\RelationGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetModified
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetModified $parameters
     * @return \StructType\RelationGetModifiedResponse|bool
     */
    public function RelationGetModified(\StructType\RelationGetModified $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetModified($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGet $parameters
     * @return \StructType\RelationGetResponse|bool
     */
    public function RelationGet(\StructType\RelationGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetImage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetImage $parameters
     * @return \StructType\RelationGetImageResponse|bool
     */
    public function RelationGetImage(\StructType\RelationGetImage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetTelephoneNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetTelephoneNumbers $parameters
     * @return \StructType\RelationGetTelephoneNumbersResponse|bool
     */
    public function RelationGetTelephoneNumbers(\StructType\RelationGetTelephoneNumbers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetTelephoneNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RelationSearchByNameAndGetTelephoneNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationSearchByNameAndGetTelephoneNumbers $parameters
     * @return \StructType\RelationSearchByNameAndGetTelephoneNumbersResponse|bool
     */
    public function RelationSearchByNameAndGetTelephoneNumbers(\StructType\RelationSearchByNameAndGetTelephoneNumbers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationSearchByNameAndGetTelephoneNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationSearchByField
     * Meta information extracted from the WSDL
     * - documentation: Search relation based on selected field containing a value
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationSearchByField $parameters
     * @return \StructType\RelationSearchByFieldResponse|bool
     */
    public function RelationSearchByField(\StructType\RelationSearchByField $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationSearchByField($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationSearchByFieldExact
     * Meta information extracted from the WSDL
     * - documentation: Search relation based on exact match of value in selected field
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationSearchByFieldExact $parameters
     * @return \StructType\RelationSearchByFieldExactResponse|bool
     */
    public function RelationSearchByFieldExact(\StructType\RelationSearchByFieldExact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationSearchByFieldExact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationSearchByName
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use RelationSearchByName_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationSearchByName $parameters
     * @return \StructType\RelationSearchByNameResponse|bool
     */
    public function RelationSearchByName(\StructType\RelationSearchByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationSearchByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationSearchByName_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationSearchByName_V2 $parameters
     * @return \StructType\RelationSearchByName_V2Response|bool
     */
    public function RelationSearchByName_V2(\StructType\RelationSearchByName_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationSearchByName_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationSearchByMark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationSearchByMark $parameters
     * @return \StructType\RelationSearchByMarkResponse|bool
     */
    public function RelationSearchByMark(\StructType\RelationSearchByMark $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationSearchByMark($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationSearchByTelephone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationSearchByTelephone $parameters
     * @return \StructType\RelationSearchByTelephoneResponse|bool
     */
    public function RelationSearchByTelephone(\StructType\RelationSearchByTelephone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationSearchByTelephone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetParentRelationships
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetParentRelationships $parameters
     * @return \StructType\RelationGetParentRelationshipsResponse|bool
     */
    public function RelationGetParentRelationships(\StructType\RelationGetParentRelationships $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetParentRelationships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetChildRelationships
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetChildRelationships $parameters
     * @return \StructType\RelationGetChildRelationshipsResponse|bool
     */
    public function RelationGetChildRelationships(\StructType\RelationGetChildRelationships $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetChildRelationships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RelationGetChildRelationshipsModified
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetChildRelationshipsModified $parameters
     * @return \StructType\RelationGetChildRelationshipsModifiedResponse|bool
     */
    public function RelationGetChildRelationshipsModified(\StructType\RelationGetChildRelationshipsModified $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetChildRelationshipsModified($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetActivities
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use RelationGetActivitiesModified_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetActivities $parameters
     * @return \StructType\RelationGetActivitiesResponse|bool
     */
    public function RelationGetActivities(\StructType\RelationGetActivities $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetActivities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetActivitiesModified
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use RelationGetActivitiesModified_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetActivitiesModified $parameters
     * @return \StructType\RelationGetActivitiesModifiedResponse|bool
     */
    public function RelationGetActivitiesModified(\StructType\RelationGetActivitiesModified $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetActivitiesModified($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetActivitiesModified_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetActivitiesModified_V2 $parameters
     * @return \StructType\RelationGetActivitiesModified_V2Response|bool
     */
    public function RelationGetActivitiesModified_V2(\StructType\RelationGetActivitiesModified_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetActivitiesModified_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetMarks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetMarks $parameters
     * @return \StructType\RelationGetMarksResponse|bool
     */
    public function RelationGetMarks(\StructType\RelationGetMarks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetMarks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetMarksModified
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetMarksModified $parameters
     * @return \StructType\RelationGetMarksModifiedResponse|bool
     */
    public function RelationGetMarksModified(\StructType\RelationGetMarksModified $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetMarksModified($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetTelephoneBook
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use RelationGetTelephoneBook_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetTelephoneBook $parameters
     * @return \StructType\RelationGetTelephoneBookResponse|bool
     */
    public function RelationGetTelephoneBook(\StructType\RelationGetTelephoneBook $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetTelephoneBook($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetTelephoneBook_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetTelephoneBook_V2 $parameters
     * @return \StructType\RelationGetTelephoneBook_V2Response|bool
     */
    public function RelationGetTelephoneBook_V2(\StructType\RelationGetTelephoneBook_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetTelephoneBook_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetAttachments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetAttachments $parameters
     * @return \StructType\RelationGetAttachmentsResponse|bool
     */
    public function RelationGetAttachments(\StructType\RelationGetAttachments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetAttachments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationGetNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationGetNotes $parameters
     * @return \StructType\RelationGetNotesResponse|bool
     */
    public function RelationGetNotes(\StructType\RelationGetNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationGetNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RelationAddAttachmentResponse|\StructType\RelationAddNoteResponse|\StructType\RelationCreateResponse|\StructType\RelationDeleteAttachmentResponse|\StructType\RelationExistsResponse|\StructType\RelationGetActivitiesModifiedResponse|\StructType\RelationGetActivitiesModified_V2Response|\StructType\RelationGetActivitiesResponse|\StructType\RelationGetAllResponse|\StructType\RelationGetAttachmentsResponse|\StructType\RelationGetChildRelationshipsModifiedResponse|\StructType\RelationGetChildRelationshipsResponse|\StructType\RelationGetFieldsResponse|\StructType\RelationGetImageResponse|\StructType\RelationGetMarksModifiedResponse|\StructType\RelationGetMarksResponse|\StructType\RelationGetModifiedResponse|\StructType\RelationGetNotesResponse|\StructType\RelationGetParentRelationshipsResponse|\StructType\RelationGetResponse|\StructType\RelationGetTelephoneBookResponse|\StructType\RelationGetTelephoneBook_V2Response|\StructType\RelationGetTelephoneNumbersResponse|\StructType\RelationSearchByFieldExactResponse|\StructType\RelationSearchByFieldResponse|\StructType\RelationSearchByMarkResponse|\StructType\RelationSearchByNameAndGetTelephoneNumbersResponse|\StructType\RelationSearchByNameResponse|\StructType\RelationSearchByName_V2Response|\StructType\RelationSearchByTelephoneResponse|\StructType\RelationUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
