<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Notifications ServiceType
 * @subpackage Services
 */
class Notifications extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NotificationsGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NotificationsGet $parameters
     * @return \StructType\NotificationsGetResponse|bool
     */
    public function NotificationsGet(\StructType\NotificationsGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NotificationsGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NotificationsGetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
