<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Notification ServiceType
 * @subpackage Services
 */
class Notification extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NotificationMarkAsRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NotificationMarkAsRead $parameters
     * @return \StructType\NotificationMarkAsReadResponse|bool
     */
    public function NotificationMarkAsRead(\StructType\NotificationMarkAsRead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NotificationMarkAsRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NotificationGetCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NotificationGetCount $parameters
     * @return \StructType\NotificationGetCountResponse|bool
     */
    public function NotificationGetCount(\StructType\NotificationGetCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NotificationGetCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NotificationGetCountResponse|\StructType\NotificationMarkAsReadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
