<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mobile ServiceType
 * @subpackage Services
 */
class Mobile extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MobileLogError
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileLogError $parameters
     * @return \StructType\MobileLogErrorResponse|bool
     */
    public function MobileLogError(\StructType\MobileLogError $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileLogError($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MobileHasAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileHasAccess $parameters
     * @return \StructType\MobileHasAccessResponse|bool
     */
    public function MobileHasAccess(\StructType\MobileHasAccess $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileHasAccess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MobileShouldUpdateApp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileShouldUpdateApp $parameters
     * @return \StructType\MobileShouldUpdateAppResponse|bool
     */
    public function MobileShouldUpdateApp(\StructType\MobileShouldUpdateApp $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileShouldUpdateApp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MobileStoreDeviceId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileStoreDeviceId $parameters
     * @return \StructType\MobileStoreDeviceIdResponse|bool
     */
    public function MobileStoreDeviceId(\StructType\MobileStoreDeviceId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileStoreDeviceId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MobileRemoveDeviceId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileRemoveDeviceId $parameters
     * @return \StructType\MobileRemoveDeviceIdResponse|bool
     */
    public function MobileRemoveDeviceId(\StructType\MobileRemoveDeviceId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileRemoveDeviceId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MobileGetTranslations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileGetTranslations $parameters
     * @return \StructType\MobileGetTranslationsResponse|bool
     */
    public function MobileGetTranslations(\StructType\MobileGetTranslations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileGetTranslations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MobileCreateAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileCreateAccount $parameters
     * @return \StructType\MobileCreateAccountResponse|bool
     */
    public function MobileCreateAccount(\StructType\MobileCreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileCreateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MobileGetCreateAccountDatastore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MobileGetCreateAccountDatastore $parameters
     * @return \StructType\MobileGetCreateAccountDatastoreResponse|bool
     */
    public function MobileGetCreateAccountDatastore(\StructType\MobileGetCreateAccountDatastore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MobileGetCreateAccountDatastore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MobileCreateAccountResponse|\StructType\MobileGetCreateAccountDatastoreResponse|\StructType\MobileGetTranslationsResponse|\StructType\MobileHasAccessResponse|\StructType\MobileLogErrorResponse|\StructType\MobileRemoveDeviceIdResponse|\StructType\MobileShouldUpdateAppResponse|\StructType\MobileStoreDeviceIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
