<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Language ServiceType
 * @subpackage Services
 */
class Language extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LanguageGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LanguageGetAll $parameters
     * @return \StructType\LanguageGetAllResponse|bool
     */
    public function LanguageGetAll(\StructType\LanguageGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LanguageGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LanguageGetAllResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
