<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Entity ServiceType
 * @subpackage Services
 */
class Entity extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EntityTypeGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EntityTypeGet $parameters
     * @return \StructType\EntityTypeGetResponse|bool
     */
    public function EntityTypeGet(\StructType\EntityTypeGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EntityTypeGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EntityTypeGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EntityTypeGetAll $parameters
     * @return \StructType\EntityTypeGetAllResponse|bool
     */
    public function EntityTypeGetAll(\StructType\EntityTypeGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EntityTypeGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EntityTypeGetFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EntityTypeGetFields $parameters
     * @return \StructType\EntityTypeGetFieldsResponse|bool
     */
    public function EntityTypeGetFields(\StructType\EntityTypeGetFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EntityTypeGetFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EntityTypeGetFields_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EntityTypeGetFields_V2 $parameters
     * @return \StructType\EntityTypeGetFields_V2Response|bool
     */
    public function EntityTypeGetFields_V2(\StructType\EntityTypeGetFields_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EntityTypeGetFields_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EntityTypeGetAllResponse|\StructType\EntityTypeGetFieldsResponse|\StructType\EntityTypeGetFields_V2Response|\StructType\EntityTypeGetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
