<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Database ServiceType
 * @subpackage Services
 */
class Database extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DatabaseHasAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatabaseHasAccess $parameters
     * @return \StructType\DatabaseHasAccessResponse|bool
     */
    public function DatabaseHasAccess(\StructType\DatabaseHasAccess $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatabaseHasAccess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DatabaseHasAccessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
