<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Api ServiceType
 * @subpackage Services
 */
class Api extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ApiGetVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApiGetVersion $parameters
     * @return \StructType\ApiGetVersionResponse|bool
     */
    public function ApiGetVersion(\StructType\ApiGetVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ApiGetVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApiGetCalls
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApiGetCalls $parameters
     * @return \StructType\ApiGetCallsResponse|bool
     */
    public function ApiGetCalls(\StructType\ApiGetCalls $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ApiGetCalls($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ApiGetCallsResponse|\StructType\ApiGetVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
