<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BaseRelationType EnumType
 * @subpackage Enumerations
 */
class BaseRelationType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotApplicable'
     * @return string 'NotApplicable'
     */
    const VALUE_NOT_APPLICABLE = 'NotApplicable';
    /**
     * Constant for value 'Person'
     * @return string 'Person'
     */
    const VALUE_PERSON = 'Person';
    /**
     * Constant for value 'Organisation'
     * @return string 'Organisation'
     */
    const VALUE_ORGANISATION = 'Organisation';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_APPLICABLE
     * @uses self::VALUE_PERSON
     * @uses self::VALUE_ORGANISATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_APPLICABLE,
            self::VALUE_PERSON,
            self::VALUE_ORGANISATION,
        );
    }
}
