<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AddressStyle EnumType
 * @subpackage Enumerations
 */
class AddressStyle extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Formal'
     * @return string 'Formal'
     */
    const VALUE_FORMAL = 'Formal';
    /**
     * Constant for value 'Informal'
     * @return string 'Informal'
     */
    const VALUE_INFORMAL = 'Informal';
    /**
     * Constant for value 'ExecutiveBoard'
     * @return string 'ExecutiveBoard'
     */
    const VALUE_EXECUTIVE_BOARD = 'ExecutiveBoard';
    /**
     * Constant for value 'Family'
     * @return string 'Family'
     */
    const VALUE_FAMILY = 'Family';
    /**
     * Constant for value 'Board'
     * @return string 'Board'
     */
    const VALUE_BOARD = 'Board';
    /**
     * Constant for value 'Partner'
     * @return string 'Partner'
     */
    const VALUE_PARTNER = 'Partner';
    /**
     * Constant for value 'Residents'
     * @return string 'Residents'
     */
    const VALUE_RESIDENTS = 'Residents';
    /**
     * Constant for value 'Owners'
     * @return string 'Owners'
     */
    const VALUE_OWNERS = 'Owners';
    /**
     * Constant for value 'FormalWithFirstnames'
     * @return string 'FormalWithFirstnames'
     */
    const VALUE_FORMAL_WITH_FIRSTNAMES = 'FormalWithFirstnames';
    /**
     * Constant for value 'FormalWithFunction'
     * @return string 'FormalWithFunction'
     */
    const VALUE_FORMAL_WITH_FUNCTION = 'FormalWithFunction';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return allowed values
     * @uses self::VALUE_FORMAL
     * @uses self::VALUE_INFORMAL
     * @uses self::VALUE_EXECUTIVE_BOARD
     * @uses self::VALUE_FAMILY
     * @uses self::VALUE_BOARD
     * @uses self::VALUE_PARTNER
     * @uses self::VALUE_RESIDENTS
     * @uses self::VALUE_OWNERS
     * @uses self::VALUE_FORMAL_WITH_FIRSTNAMES
     * @uses self::VALUE_FORMAL_WITH_FUNCTION
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FORMAL,
            self::VALUE_INFORMAL,
            self::VALUE_EXECUTIVE_BOARD,
            self::VALUE_FAMILY,
            self::VALUE_BOARD,
            self::VALUE_PARTNER,
            self::VALUE_RESIDENTS,
            self::VALUE_OWNERS,
            self::VALUE_FORMAL_WITH_FIRSTNAMES,
            self::VALUE_FORMAL_WITH_FUNCTION,
            self::VALUE_NONE,
        );
    }
}
