<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'NoteGet' => '\\StructType\\NoteGet',
            'ApiCredentials' => '\\StructType\\ApiCredentials',
            'ApiSourceApplication' => '\\StructType\\ApiSourceApplication',
            'NoteGetResponse' => '\\StructType\\NoteGetResponse',
            'NoteGetResult' => '\\StructType\\NoteGetResult',
            'PvApiResult' => '\\StructType\\PvApiResult',
            'PvApiResultOfObject' => '\\StructType\\PvApiResultOfObject',
            'PvApiResultDataOfObject' => '\\StructType\\PvApiResultDataOfObject',
            'PvNoteData' => '\\StructType\\PvNoteData',
            'AttachmentGetLabels' => '\\StructType\\AttachmentGetLabels',
            'PvLabelItemData' => '\\StructType\\PvLabelItemData',
            'ArrayOfPvLabelItemData' => '\\ArrayType\\ArrayOfPvLabelItemData',
            'AttachmentGetLabelsResponse' => '\\StructType\\AttachmentGetLabelsResponse',
            'AttachmentGetLabelsResult' => '\\StructType\\AttachmentGetLabelsResult',
            'ActivityGetLabels' => '\\StructType\\ActivityGetLabels',
            'ActivityGetLabelsResponse' => '\\StructType\\ActivityGetLabelsResponse',
            'ActivityGetLabelsResult' => '\\StructType\\ActivityGetLabelsResult',
            'RelationshipFieldGetLabels' => '\\StructType\\RelationshipFieldGetLabels',
            'RelationshipFieldGetLabelsResponse' => '\\StructType\\RelationshipFieldGetLabelsResponse',
            'RelationshipGetLabelsResult' => '\\StructType\\RelationshipGetLabelsResult',
            'ActivityCreate' => '\\StructType\\ActivityCreate',
            'PvActivitySettingsData' => '\\StructType\\PvActivitySettingsData',
            'PvActivityFollowUpData' => '\\StructType\\PvActivityFollowUpData',
            'ArrayOfPvFieldValueData' => '\\ArrayType\\ArrayOfPvFieldValueData',
            'PvFieldValueData' => '\\StructType\\PvFieldValueData',
            'PvActivityData' => '\\StructType\\PvActivityData',
            'PvRelationshipData' => '\\StructType\\PvRelationshipData',
            'PvAuditData' => '\\StructType\\PvAuditData',
            'PvFieldValuesData' => '\\StructType\\PvFieldValuesData',
            'PvActivityAuditData' => '\\StructType\\PvActivityAuditData',
            'ArrayOfPvCounterData' => '\\ArrayType\\ArrayOfPvCounterData',
            'PvCounterData' => '\\StructType\\PvCounterData',
            'ActivityCreateResponse' => '\\StructType\\ActivityCreateResponse',
            'ActivityCreateResult' => '\\StructType\\ActivityCreateResult',
            'ActivityUpdate' => '\\StructType\\ActivityUpdate',
            'ActivityUpdateResponse' => '\\StructType\\ActivityUpdateResponse',
            'ActivityUpdateResult' => '\\StructType\\ActivityUpdateResult',
            'ActivityAddReference' => '\\StructType\\ActivityAddReference',
            'ActivityAddReferenceResponse' => '\\StructType\\ActivityAddReferenceResponse',
            'ActivityAddReferenceResult' => '\\StructType\\ActivityAddReferenceResult',
            'ActivityFlow' => '\\StructType\\ActivityFlow',
            'ActivityFlowResponse' => '\\StructType\\ActivityFlowResponse',
            'ActivityFlowResult' => '\\StructType\\ActivityFlowResult',
            'ActivityClose' => '\\StructType\\ActivityClose',
            'ActivityCloseResponse' => '\\StructType\\ActivityCloseResponse',
            'ActivityCloseResult' => '\\StructType\\ActivityCloseResult',
            'ActivityAddAttachment' => '\\StructType\\ActivityAddAttachment',
            'PvAttachmentData' => '\\StructType\\PvAttachmentData',
            'ActivityAddAttachmentResponse' => '\\StructType\\ActivityAddAttachmentResponse',
            'ActivityAddAttachmentResult' => '\\StructType\\ActivityAddAttachmentResult',
            'ActivityDeleteAttachment' => '\\StructType\\ActivityDeleteAttachment',
            'ActivityDeleteAttachmentResponse' => '\\StructType\\ActivityDeleteAttachmentResponse',
            'ActivityDeleteAttachmentResult' => '\\StructType\\ActivityDeleteAttachmentResult',
            'ActivityAddNote' => '\\StructType\\ActivityAddNote',
            'ActivityAddNoteResponse' => '\\StructType\\ActivityAddNoteResponse',
            'ActivityAddNoteResult' => '\\StructType\\ActivityAddNoteResult',
            'ActivityAddNote_V2' => '\\StructType\\ActivityAddNote_V2',
            'ActivityAddNote_V2Response' => '\\StructType\\ActivityAddNote_V2Response',
            'ActivityAddNote_V3' => '\\StructType\\ActivityAddNote_V3',
            'ActivityAddNote_V3Response' => '\\StructType\\ActivityAddNote_V3Response',
            'ActivityAddNoteV3Result' => '\\StructType\\ActivityAddNoteV3Result',
            'ActivityAddInvolved' => '\\StructType\\ActivityAddInvolved',
            'ActivityAddInvolvedResponse' => '\\StructType\\ActivityAddInvolvedResponse',
            'ActivityAddInvolvedResult' => '\\StructType\\ActivityAddInvolvedResult',
            'ActivityAddProductLine' => '\\StructType\\ActivityAddProductLine',
            'PvProductLineData' => '\\StructType\\PvProductLineData',
            'ActivityAddProductLineResponse' => '\\StructType\\ActivityAddProductLineResponse',
            'ActivityAddProductLineResult' => '\\StructType\\ActivityAddProductLineResult',
            'ActivityDeleteProductLine' => '\\StructType\\ActivityDeleteProductLine',
            'ActivityDeleteProductLineResponse' => '\\StructType\\ActivityDeleteProductLineResponse',
            'ActivityDeleteProductLineResult' => '\\StructType\\ActivityDeleteProductLineResult',
            'ActivityDeleteProductLines' => '\\StructType\\ActivityDeleteProductLines',
            'ActivityDeleteProductLinesResponse' => '\\StructType\\ActivityDeleteProductLinesResponse',
            'ActivityDeleteProductLinesResult' => '\\StructType\\ActivityDeleteProductLinesResult',
            'ActivityAddParameters' => '\\StructType\\ActivityAddParameters',
            'ArrayOfActivityParameter' => '\\ArrayType\\ArrayOfActivityParameter',
            'ActivityParameter' => '\\StructType\\ActivityParameter',
            'ActivityAddParametersResponse' => '\\StructType\\ActivityAddParametersResponse',
            'ActivityAddParametersResult' => '\\StructType\\ActivityAddParametersResult',
            'ActivityAddLine' => '\\StructType\\ActivityAddLine',
            'PvLineData' => '\\StructType\\PvLineData',
            'ActivityAddLineResponse' => '\\StructType\\ActivityAddLineResponse',
            'ActivityAddLineResult' => '\\StructType\\ActivityAddLineResult',
            'ActivityAddLineV2' => '\\StructType\\ActivityAddLineV2',
            'ActivityAddLineV2Response' => '\\StructType\\ActivityAddLineV2Response',
            'SubscriptionCreate' => '\\StructType\\SubscriptionCreate',
            'SubscriptionCreateResponse' => '\\StructType\\SubscriptionCreateResponse',
            'SubscriptionCreateResult' => '\\StructType\\SubscriptionCreateResult',
            'SubscriptionUpdate' => '\\StructType\\SubscriptionUpdate',
            'SubscriptionUpdateResponse' => '\\StructType\\SubscriptionUpdateResponse',
            'SubscriptionAddProductLine' => '\\StructType\\SubscriptionAddProductLine',
            'SubscriptionAddProductLineResponse' => '\\StructType\\SubscriptionAddProductLineResponse',
            'SubscriptionAddProductLineResult' => '\\StructType\\SubscriptionAddProductLineResult',
            'RelationCreate' => '\\StructType\\RelationCreate',
            'PvRelationData' => '\\StructType\\PvRelationData',
            'RelationCreateResponse' => '\\StructType\\RelationCreateResponse',
            'RelationCreateResult' => '\\StructType\\RelationCreateResult',
            'RelationUpdate' => '\\StructType\\RelationUpdate',
            'RelationUpdateResponse' => '\\StructType\\RelationUpdateResponse',
            'RelationUpdateResult' => '\\StructType\\RelationUpdateResult',
            'RelationAddAttachment' => '\\StructType\\RelationAddAttachment',
            'RelationAddAttachmentResponse' => '\\StructType\\RelationAddAttachmentResponse',
            'RelationAddAttachmentResult' => '\\StructType\\RelationAddAttachmentResult',
            'RelationDeleteAttachment' => '\\StructType\\RelationDeleteAttachment',
            'RelationDeleteAttachmentResponse' => '\\StructType\\RelationDeleteAttachmentResponse',
            'RelationDeleteAttachmentResult' => '\\StructType\\RelationDeleteAttachmentResult',
            'RelationAddNote' => '\\StructType\\RelationAddNote',
            'RelationAddNoteResponse' => '\\StructType\\RelationAddNoteResponse',
            'RelationAddNoteResult' => '\\StructType\\RelationAddNoteResult',
            'RelationshipCreate' => '\\StructType\\RelationshipCreate',
            'RelationshipCreateResponse' => '\\StructType\\RelationshipCreateResponse',
            'RelationshipCreateResult' => '\\StructType\\RelationshipCreateResult',
            'RelationshipUpdate' => '\\StructType\\RelationshipUpdate',
            'RelationshipUpdateResponse' => '\\StructType\\RelationshipUpdateResponse',
            'RelationshipUpdateResult' => '\\StructType\\RelationshipUpdateResult',
            'RelationshipAddMark' => '\\StructType\\RelationshipAddMark',
            'PvRelationshipMarkData' => '\\StructType\\PvRelationshipMarkData',
            'RelationshipAddMarkResponse' => '\\StructType\\RelationshipAddMarkResponse',
            'RelationshipAddMarkResult' => '\\StructType\\RelationshipAddMarkResult',
            'RelationshipAddMarkV2' => '\\StructType\\RelationshipAddMarkV2',
            'RelationshipAddMarkV2Response' => '\\StructType\\RelationshipAddMarkV2Response',
            'RelationshipRemoveMark' => '\\StructType\\RelationshipRemoveMark',
            'RelationshipRemoveMarkResponse' => '\\StructType\\RelationshipRemoveMarkResponse',
            'RelationshipRemoveMarkResult' => '\\StructType\\RelationshipRemoveMarkResult',
            'NoteUpdate' => '\\StructType\\NoteUpdate',
            'NoteUpdateResponse' => '\\StructType\\NoteUpdateResponse',
            'NoteUpdateResult' => '\\StructType\\NoteUpdateResult',
            'AttachmentUpdate' => '\\StructType\\AttachmentUpdate',
            'AttachmentUpdateResponse' => '\\StructType\\AttachmentUpdateResponse',
            'AttachmentUpdateResult' => '\\StructType\\AttachmentUpdateResult',
            'ProductGroupCreate' => '\\StructType\\ProductGroupCreate',
            'PvProductGroupData' => '\\StructType\\PvProductGroupData',
            'ProductGroupCreateResponse' => '\\StructType\\ProductGroupCreateResponse',
            'ProductGroupCreateResult' => '\\StructType\\ProductGroupCreateResult',
            'ProductGroupUpdate' => '\\StructType\\ProductGroupUpdate',
            'ProductGroupUpdateResponse' => '\\StructType\\ProductGroupUpdateResponse',
            'ProductGroupUpdateResult' => '\\StructType\\ProductGroupUpdateResult',
            'ProductCreate' => '\\StructType\\ProductCreate',
            'PvProductData' => '\\StructType\\PvProductData',
            'ProductCreateResponse' => '\\StructType\\ProductCreateResponse',
            'ProductCreateResult' => '\\StructType\\ProductCreateResult',
            'ProductCreate_V2' => '\\StructType\\ProductCreate_V2',
            'PvProductData_V2' => '\\StructType\\PvProductData_V2',
            'ProductCreate_V2Response' => '\\StructType\\ProductCreate_V2Response',
            'ProductCreateResult_V2' => '\\StructType\\ProductCreateResult_V2',
            'ProductUpdate' => '\\StructType\\ProductUpdate',
            'ProductUpdateResponse' => '\\StructType\\ProductUpdateResponse',
            'ProductUpdateResult' => '\\StructType\\ProductUpdateResult',
            'ProductUpdate_V2' => '\\StructType\\ProductUpdate_V2',
            'ProductUpdate_V2Response' => '\\StructType\\ProductUpdate_V2Response',
            'DatastoreCreateItem' => '\\StructType\\DatastoreCreateItem',
            'PvDatastoreItemData' => '\\StructType\\PvDatastoreItemData',
            'DatastoreCreateItemResponse' => '\\StructType\\DatastoreCreateItemResponse',
            'DatastoreCreateItemResult' => '\\StructType\\DatastoreCreateItemResult',
            'DatastoreCreateItem_V2' => '\\StructType\\DatastoreCreateItem_V2',
            'ArrayOfPvTranslationData2' => '\\ArrayType\\ArrayOfPvTranslationData2',
            'PvTranslationData2' => '\\StructType\\PvTranslationData2',
            'PvDatastoreItemData_V2' => '\\StructType\\PvDatastoreItemData_V2',
            'DatastoreCreateItem_V2Response' => '\\StructType\\DatastoreCreateItem_V2Response',
            'DatastoreCreateItemResult_V2' => '\\StructType\\DatastoreCreateItemResult_V2',
            'DatastoreCreateItem_V3' => '\\StructType\\DatastoreCreateItem_V3',
            'PvDatastoreItemData_V3' => '\\StructType\\PvDatastoreItemData_V3',
            'DatastoreCreateItem_V3Response' => '\\StructType\\DatastoreCreateItem_V3Response',
            'DatastoreCreateItemResult_V3' => '\\StructType\\DatastoreCreateItemResult_V3',
            'DatastoreUpdateItem' => '\\StructType\\DatastoreUpdateItem',
            'DatastoreUpdateItemResponse' => '\\StructType\\DatastoreUpdateItemResponse',
            'DatastoreUpdateItemResult' => '\\StructType\\DatastoreUpdateItemResult',
            'DatastoreUpdateItem_V2' => '\\StructType\\DatastoreUpdateItem_V2',
            'DatastoreUpdateItem_V2Response' => '\\StructType\\DatastoreUpdateItem_V2Response',
            'DatastoreDeleteItem' => '\\StructType\\DatastoreDeleteItem',
            'DatastoreDeleteItemResponse' => '\\StructType\\DatastoreDeleteItemResponse',
            'DatastoreDeleteItemResult' => '\\StructType\\DatastoreDeleteItemResult',
            'MarkAdd' => '\\StructType\\MarkAdd',
            'PvMarkData' => '\\StructType\\PvMarkData',
            'MarkAddResponse' => '\\StructType\\MarkAddResponse',
            'AddMarkResult' => '\\StructType\\AddMarkResult',
            'NotificationMarkAsRead' => '\\StructType\\NotificationMarkAsRead',
            'NotificationMarkAsReadResponse' => '\\StructType\\NotificationMarkAsReadResponse',
            'NotificationMarkAsReadResult' => '\\StructType\\NotificationMarkAsReadResult',
            'UserAddRoles' => '\\StructType\\UserAddRoles',
            'ArrayOfGuid' => '\\ArrayType\\ArrayOfGuid',
            'UserAddRolesResponse' => '\\StructType\\UserAddRolesResponse',
            'UserAddRolesResult' => '\\StructType\\UserAddRolesResult',
            'AttachmentAddLabel' => '\\StructType\\AttachmentAddLabel',
            'AttachmentAddLabelResponse' => '\\StructType\\AttachmentAddLabelResponse',
            'AddLabelResult' => '\\StructType\\AddLabelResult',
            'ActivityAddLabel' => '\\StructType\\ActivityAddLabel',
            'ActivityAddLabelResponse' => '\\StructType\\ActivityAddLabelResponse',
            'ActivityAddFieldLabel' => '\\StructType\\ActivityAddFieldLabel',
            'ActivityAddFieldLabelResponse' => '\\StructType\\ActivityAddFieldLabelResponse',
            'RelationshipAddFieldLabel' => '\\StructType\\RelationshipAddFieldLabel',
            'RelationshipAddFieldLabelResponse' => '\\StructType\\RelationshipAddFieldLabelResponse',
            'RelationshipAddLine' => '\\StructType\\RelationshipAddLine',
            'RelationshipAddLineResponse' => '\\StructType\\RelationshipAddLineResponse',
            'RelationshipAddLineResult' => '\\StructType\\RelationshipAddLineResult',
            'RelationshipAddLineV2' => '\\StructType\\RelationshipAddLineV2',
            'RelationshipAddLineV2Response' => '\\StructType\\RelationshipAddLineV2Response',
            'LabelDelete' => '\\StructType\\LabelDelete',
            'LabelDeleteResponse' => '\\StructType\\LabelDeleteResponse',
            'LabelDeleteResult' => '\\StructType\\LabelDeleteResult',
            'MobileLogError' => '\\StructType\\MobileLogError',
            'MobileLogErrorResponse' => '\\StructType\\MobileLogErrorResponse',
            'MobileLogErrorResult' => '\\StructType\\MobileLogErrorResult',
            'MobileHasAccess' => '\\StructType\\MobileHasAccess',
            'MobileHasAccessResponse' => '\\StructType\\MobileHasAccessResponse',
            'MobileHasAccessResult' => '\\StructType\\MobileHasAccessResult',
            'MobileShouldUpdateApp' => '\\StructType\\MobileShouldUpdateApp',
            'MobileShouldUpdateAppResponse' => '\\StructType\\MobileShouldUpdateAppResponse',
            'MobileShouldUpdateAppResult' => '\\StructType\\MobileShouldUpdateAppResult',
            'MobileStoreDeviceId' => '\\StructType\\MobileStoreDeviceId',
            'MobileStoreDeviceIdResponse' => '\\StructType\\MobileStoreDeviceIdResponse',
            'MobileStoreDeviceIdResult' => '\\StructType\\MobileStoreDeviceIdResult',
            'MobileRemoveDeviceId' => '\\StructType\\MobileRemoveDeviceId',
            'MobileRemoveDeviceIdResponse' => '\\StructType\\MobileRemoveDeviceIdResponse',
            'MobileRemoveDeviceIdResult' => '\\StructType\\MobileRemoveDeviceIdResult',
            'MobileGetTranslations' => '\\StructType\\MobileGetTranslations',
            'PvTranslationData' => '\\StructType\\PvTranslationData',
            'ArrayOfPvTranslationData' => '\\ArrayType\\ArrayOfPvTranslationData',
            'MobileGetTranslationsResponse' => '\\StructType\\MobileGetTranslationsResponse',
            'MobileGetTranslationsResult' => '\\StructType\\MobileGetTranslationsResult',
            'MobileCreateAccount' => '\\StructType\\MobileCreateAccount',
            'CreateDatabaseData' => '\\StructType\\CreateDatabaseData',
            'Database' => '\\StructType\\Database',
            'Organisation' => '\\StructType\\Organisation',
            'Person' => '\\StructType\\Person',
            'Employee' => '\\StructType\\Employee',
            'Lead' => '\\StructType\\Lead',
            'Workflow' => '\\StructType\\Workflow',
            'ArrayOfParameter' => '\\ArrayType\\ArrayOfParameter',
            'Parameter' => '\\StructType\\Parameter',
            'MobileCreateAccountResponse' => '\\StructType\\MobileCreateAccountResponse',
            'MobileCreateAccountResult' => '\\StructType\\MobileCreateAccountResult',
            'MobileGetCreateAccountDatastore' => '\\StructType\\MobileGetCreateAccountDatastore',
            'ArrayOfPvDatastoreItemData' => '\\ArrayType\\ArrayOfPvDatastoreItemData',
            'MobileGetCreateAccountDatastoreResponse' => '\\StructType\\MobileGetCreateAccountDatastoreResponse',
            'MobileGetCreateAccountDatastoreResult' => '\\StructType\\MobileGetCreateAccountDatastoreResult',
            'UserGetNavigationItems' => '\\StructType\\UserGetNavigationItems',
            'PvNavigationItemData' => '\\StructType\\PvNavigationItemData',
            'ArrayOfPvNavigationItemData' => '\\ArrayType\\ArrayOfPvNavigationItemData',
            'UserGetNavigationItemsResponse' => '\\StructType\\UserGetNavigationItemsResponse',
            'UserGetNavigationItemsResult' => '\\StructType\\UserGetNavigationItemsResult',
            'UserGetCreateMenuItems' => '\\StructType\\UserGetCreateMenuItems',
            'PvMenuItemData' => '\\StructType\\PvMenuItemData',
            'ArrayOfPvMenuItemData' => '\\ArrayType\\ArrayOfPvMenuItemData',
            'UserGetCreateMenuItemsResponse' => '\\StructType\\UserGetCreateMenuItemsResponse',
            'UserGetCreateMenuItemsResult' => '\\StructType\\UserGetCreateMenuItemsResult',
            'UserGetViewDefinitions' => '\\StructType\\UserGetViewDefinitions',
            'PvViewDefinitionData' => '\\StructType\\PvViewDefinitionData',
            'ArrayOfPvViewDefinitionData' => '\\ArrayType\\ArrayOfPvViewDefinitionData',
            'UserGetViewDefinitionsResponse' => '\\StructType\\UserGetViewDefinitionsResponse',
            'UserGetViewDefinitionsResult' => '\\StructType\\UserGetViewDefinitionsResult',
            'RelationshipViewGetData' => '\\StructType\\RelationshipViewGetData',
            'ArrayOfPvRelationshipData' => '\\ArrayType\\ArrayOfPvRelationshipData',
            'RelationshipViewGetDataResponse' => '\\StructType\\RelationshipViewGetDataResponse',
            'RelationshipViewGetDataResult' => '\\StructType\\RelationshipViewGetDataResult',
            'ActivityViewGetData' => '\\StructType\\ActivityViewGetData',
            'ArrayOfPvActivityData' => '\\ArrayType\\ArrayOfPvActivityData',
            'ActivityViewGetDataResponse' => '\\StructType\\ActivityViewGetDataResponse',
            'ActivityViewGetDataResult' => '\\StructType\\ActivityViewGetDataResult',
            'HasAccess' => '\\StructType\\HasAccess',
            'HasAccessResponse' => '\\StructType\\HasAccessResponse',
            'HasAccessResult' => '\\StructType\\HasAccessResult',
            'ApiGetVersion' => '\\StructType\\ApiGetVersion',
            'ApiGetVersionResponse' => '\\StructType\\ApiGetVersionResponse',
            'ApiGetVersionResult' => '\\StructType\\ApiGetVersionResult',
            'ApiGetCalls' => '\\StructType\\ApiGetCalls',
            'ApiGetCallsResponse' => '\\StructType\\ApiGetCallsResponse',
            'ApiGetCallsResult' => '\\StructType\\ApiGetCallsResult',
            'DatabaseHasAccess' => '\\StructType\\DatabaseHasAccess',
            'DatabaseHasAccessResponse' => '\\StructType\\DatabaseHasAccessResponse',
            'DatabaseHasAccessResult' => '\\StructType\\DatabaseHasAccessResult',
            'EnumerationGetItems' => '\\StructType\\EnumerationGetItems',
            'PvEnumerationItemData' => '\\StructType\\PvEnumerationItemData',
            'ArrayOfPvEnumerationItemData' => '\\ArrayType\\ArrayOfPvEnumerationItemData',
            'EnumerationGetItemsResponse' => '\\StructType\\EnumerationGetItemsResponse',
            'EnumerationGetItemsResult' => '\\StructType\\EnumerationGetItemsResult',
            'ActivityInvolvedEntityTypesGet' => '\\StructType\\ActivityInvolvedEntityTypesGet',
            'PvEntityTypeData' => '\\StructType\\PvEntityTypeData',
            'ArrayOfPvEntityTypeData' => '\\ArrayType\\ArrayOfPvEntityTypeData',
            'ActivityInvolvedEntityTypesGetResponse' => '\\StructType\\ActivityInvolvedEntityTypesGetResponse',
            'ActivityInvolvedEntityTypesGetResult' => '\\StructType\\ActivityInvolvedEntityTypesGetResult',
            'EntityTypeGet' => '\\StructType\\EntityTypeGet',
            'EntityTypeGetResponse' => '\\StructType\\EntityTypeGetResponse',
            'EntityTypeGetResult' => '\\StructType\\EntityTypeGetResult',
            'EntityTypeGetAll' => '\\StructType\\EntityTypeGetAll',
            'EntityTypeGetAllResponse' => '\\StructType\\EntityTypeGetAllResponse',
            'EntityTypeGetAllResult' => '\\StructType\\EntityTypeGetAllResult',
            'WorkflowGet' => '\\StructType\\WorkflowGet',
            'PvWorkflowData' => '\\StructType\\PvWorkflowData',
            'WorkflowGetResponse' => '\\StructType\\WorkflowGetResponse',
            'WorkflowGetResult' => '\\StructType\\WorkflowGetResult',
            'WorkflowGetAll' => '\\StructType\\WorkflowGetAll',
            'ArrayOfPvWorkflowData' => '\\ArrayType\\ArrayOfPvWorkflowData',
            'WorkflowGetAllResponse' => '\\StructType\\WorkflowGetAllResponse',
            'WorkflowGetAllResult' => '\\StructType\\WorkflowGetAllResult',
            'WorkflowStepGet' => '\\StructType\\WorkflowStepGet',
            'PvWorkflowStepData' => '\\StructType\\PvWorkflowStepData',
            'WorkflowStepGetResponse' => '\\StructType\\WorkflowStepGetResponse',
            'WorkflowStepGetResult' => '\\StructType\\WorkflowStepGetResult',
            'WorkflowStepGetAll' => '\\StructType\\WorkflowStepGetAll',
            'ArrayOfPvWorkflowStepData' => '\\ArrayType\\ArrayOfPvWorkflowStepData',
            'WorkflowStepGetAllResponse' => '\\StructType\\WorkflowStepGetAllResponse',
            'WorkflowStepGetAllResult' => '\\StructType\\WorkflowStepGetAllResult',
            'WorkflowGetQueues' => '\\StructType\\WorkflowGetQueues',
            'PvQueueData' => '\\StructType\\PvQueueData',
            'ArrayOfPvQueueData' => '\\ArrayType\\ArrayOfPvQueueData',
            'WorkflowGetQueuesResponse' => '\\StructType\\WorkflowGetQueuesResponse',
            'WorkflowGetQueuesResult' => '\\StructType\\WorkflowGetQueuesResult',
            'FieldGet' => '\\StructType\\FieldGet',
            'PvFieldData' => '\\StructType\\PvFieldData',
            'FieldGetResponse' => '\\StructType\\FieldGetResponse',
            'FieldGetResult' => '\\StructType\\FieldGetResult',
            'EntityTypeGetFields' => '\\StructType\\EntityTypeGetFields',
            'ArrayOfPvFieldData' => '\\ArrayType\\ArrayOfPvFieldData',
            'EntityTypeGetFieldsResponse' => '\\StructType\\EntityTypeGetFieldsResponse',
            'EntityTypeGetFieldsResult' => '\\StructType\\EntityTypeGetFieldsResult',
            'EntityTypeGetFields_V2' => '\\StructType\\EntityTypeGetFields_V2',
            'EntityTypeGetFields_V2Response' => '\\StructType\\EntityTypeGetFields_V2Response',
            'ActivityGetFields' => '\\StructType\\ActivityGetFields',
            'ActivityGetFieldsResponse' => '\\StructType\\ActivityGetFieldsResponse',
            'ActivityGetFieldsResult' => '\\StructType\\ActivityGetFieldsResult',
            'RelationshipGetFields' => '\\StructType\\RelationshipGetFields',
            'RelationshipGetFieldsResponse' => '\\StructType\\RelationshipGetFieldsResponse',
            'RelationshipGetFieldsResult' => '\\StructType\\RelationshipGetFieldsResult',
            'RelationGetFields' => '\\StructType\\RelationGetFields',
            'RelationGetFieldsResponse' => '\\StructType\\RelationGetFieldsResponse',
            'RelationGetFieldsResult' => '\\StructType\\RelationGetFieldsResult',
            'UserGetDatabases' => '\\StructType\\UserGetDatabases',
            'PvUserDatabase' => '\\StructType\\PvUserDatabase',
            'ArrayOfPvUserDatabase' => '\\ArrayType\\ArrayOfPvUserDatabase',
            'UserGetDatabasesResponse' => '\\StructType\\UserGetDatabasesResponse',
            'UserGetDatabasesResult' => '\\StructType\\UserGetDatabasesResult',
            'UsersGetActive' => '\\StructType\\UsersGetActive',
            'PvUserData' => '\\StructType\\PvUserData',
            'ArrayOfPvUserData' => '\\ArrayType\\ArrayOfPvUserData',
            'UsersGetActiveResponse' => '\\StructType\\UsersGetActiveResponse',
            'UsersGetActiveResult' => '\\StructType\\UsersGetActiveResult',
            'UsersGetRoles' => '\\StructType\\UsersGetRoles',
            'PvRoleData' => '\\StructType\\PvRoleData',
            'ArrayOfPvRoleData' => '\\ArrayType\\ArrayOfPvRoleData',
            'UsersGetRolesResponse' => '\\StructType\\UsersGetRolesResponse',
            'UsersGetRolesResult' => '\\StructType\\UsersGetRolesResult',
            'UsersGetLanguage' => '\\StructType\\UsersGetLanguage',
            'UsersGetLanguageResponse' => '\\StructType\\UsersGetLanguageResponse',
            'UsersGetLanguageResult' => '\\StructType\\UsersGetLanguageResult',
            'UsersSetLanguage' => '\\StructType\\UsersSetLanguage',
            'UsersSetLanguageResponse' => '\\StructType\\UsersSetLanguageResponse',
            'UsersSetLanguageResult' => '\\StructType\\UsersSetLanguageResult',
            'LanguageGetAll' => '\\StructType\\LanguageGetAll',
            'PvLanguageData' => '\\StructType\\PvLanguageData',
            'ArrayOfPvLanguageData' => '\\ArrayType\\ArrayOfPvLanguageData',
            'LanguageGetAllResponse' => '\\StructType\\LanguageGetAllResponse',
            'LanguageGetAllResult' => '\\StructType\\LanguageGetAllResult',
            'RoleGetAll' => '\\StructType\\RoleGetAll',
            'RoleGetAllResponse' => '\\StructType\\RoleGetAllResponse',
            'RoleGetAllResult' => '\\StructType\\RoleGetAllResult',
            'RoleGetObjectRights' => '\\StructType\\RoleGetObjectRights',
            'PvObjectRightData' => '\\StructType\\PvObjectRightData',
            'ArrayOfPvObjectRightData' => '\\ArrayType\\ArrayOfPvObjectRightData',
            'RoleGetObjectRightsResponse' => '\\StructType\\RoleGetObjectRightsResponse',
            'RoleGetObjectRightsResult' => '\\StructType\\RoleGetObjectRightsResult',
            'MarkGetAll' => '\\StructType\\MarkGetAll',
            'ArrayOfPvMarkData' => '\\ArrayType\\ArrayOfPvMarkData',
            'MarkGetAllResponse' => '\\StructType\\MarkGetAllResponse',
            'MarkGetAllResult' => '\\StructType\\MarkGetAllResult',
            'MarkGetAllV2' => '\\StructType\\MarkGetAllV2',
            'PvMarkDataV2' => '\\StructType\\PvMarkDataV2',
            'ArrayOfPvMarkDataV2' => '\\ArrayType\\ArrayOfPvMarkDataV2',
            'MarkGetAllV2Response' => '\\StructType\\MarkGetAllV2Response',
            'MarkGetAllV2Result' => '\\StructType\\MarkGetAllV2Result',
            'CampaignMarkGetAll' => '\\StructType\\CampaignMarkGetAll',
            'CampaignMarkGetAllResponse' => '\\StructType\\CampaignMarkGetAllResponse',
            'CampaignMarkGetAllResult' => '\\StructType\\CampaignMarkGetAllResult',
            'ParameterGet' => '\\StructType\\ParameterGet',
            'PvParameterData' => '\\StructType\\PvParameterData',
            'ParameterGetResponse' => '\\StructType\\ParameterGetResponse',
            'ParameterGetResult' => '\\StructType\\ParameterGetResult',
            'ProductGetVatCodes' => '\\StructType\\ProductGetVatCodes',
            'PvVatData' => '\\StructType\\PvVatData',
            'ArrayOfPvVatData' => '\\ArrayType\\ArrayOfPvVatData',
            'ProductGetVatCodesResponse' => '\\StructType\\ProductGetVatCodesResponse',
            'ProductGetVatCodesResult' => '\\StructType\\ProductGetVatCodesResult',
            'ProductGetUnits' => '\\StructType\\ProductGetUnits',
            'ProductGetUnitsResponse' => '\\StructType\\ProductGetUnitsResponse',
            'ProductGetUnitsResult' => '\\StructType\\ProductGetUnitsResult',
            'ProductGetUnits_V2' => '\\StructType\\ProductGetUnits_V2',
            'PvUnitData' => '\\StructType\\PvUnitData',
            'ArrayOfPvUnitData' => '\\ArrayType\\ArrayOfPvUnitData',
            'ProductGetUnits_V2Response' => '\\StructType\\ProductGetUnits_V2Response',
            'ProductGetUnitsResult_V2' => '\\StructType\\ProductGetUnitsResult_V2',
            'ProductGetTypes' => '\\StructType\\ProductGetTypes',
            'ProductGetTypesResponse' => '\\StructType\\ProductGetTypesResponse',
            'ProductGetTypesResult' => '\\StructType\\ProductGetTypesResult',
            'ActivityExists' => '\\StructType\\ActivityExists',
            'ActivityExistsResponse' => '\\StructType\\ActivityExistsResponse',
            'ActivityExistsResult' => '\\StructType\\ActivityExistsResult',
            'ActivityGet' => '\\StructType\\ActivityGet',
            'ActivityGetResponse' => '\\StructType\\ActivityGetResponse',
            'ActivityGetResult' => '\\StructType\\ActivityGetResult',
            'ActivityGetConnectedActivities' => '\\StructType\\ActivityGetConnectedActivities',
            'ActivityGetConnectedActivitiesResponse' => '\\StructType\\ActivityGetConnectedActivitiesResponse',
            'ActivityGetConnectedActivitiesResult' => '\\StructType\\ActivityGetConnectedActivitiesResult',
            'ActivitySearchByField' => '\\StructType\\ActivitySearchByField',
            'ActivitySearchByFieldResponse' => '\\StructType\\ActivitySearchByFieldResponse',
            'ActivitySearchByFieldResult' => '\\StructType\\ActivitySearchByFieldResult',
            'ActivitySearchByFieldInPeriod' => '\\StructType\\ActivitySearchByFieldInPeriod',
            'ActivitySearchByFieldInPeriodResponse' => '\\StructType\\ActivitySearchByFieldInPeriodResponse',
            'ActivitySearchByFieldInPeriodResult' => '\\StructType\\ActivitySearchByFieldInPeriodResult',
            'ActivitySearchByFieldInPeriodExact' => '\\StructType\\ActivitySearchByFieldInPeriodExact',
            'ActivitySearchByFieldInPeriodExactResponse' => '\\StructType\\ActivitySearchByFieldInPeriodExactResponse',
            'ActivitySearchByFieldInPeriodExactResult' => '\\StructType\\ActivitySearchByFieldInPeriodExactResult',
            'ActivityGetAttachments' => '\\StructType\\ActivityGetAttachments',
            'ArrayOfPvAttachmentData' => '\\ArrayType\\ArrayOfPvAttachmentData',
            'ActivityGetAttachmentsResponse' => '\\StructType\\ActivityGetAttachmentsResponse',
            'ActivityGetAttachmentsResult' => '\\StructType\\ActivityGetAttachmentsResult',
            'ActivityGetAttachments_V2' => '\\StructType\\ActivityGetAttachments_V2',
            'ActivityGetAttachments_V2Response' => '\\StructType\\ActivityGetAttachments_V2Response',
            'ActivityGetNotes' => '\\StructType\\ActivityGetNotes',
            'ArrayOfPvNoteData' => '\\ArrayType\\ArrayOfPvNoteData',
            'ActivityGetNotesResponse' => '\\StructType\\ActivityGetNotesResponse',
            'ActivityGetNotesResult' => '\\StructType\\ActivityGetNotesResult',
            'ActivityGetNotes_V2' => '\\StructType\\ActivityGetNotes_V2',
            'ActivityGetNotes_V2Response' => '\\StructType\\ActivityGetNotes_V2Response',
            'ActivityGetInvolveds' => '\\StructType\\ActivityGetInvolveds',
            'PvInvolvedData' => '\\StructType\\PvInvolvedData',
            'ArrayOfPvInvolvedData' => '\\ArrayType\\ArrayOfPvInvolvedData',
            'ActivityGetInvolvedsResponse' => '\\StructType\\ActivityGetInvolvedsResponse',
            'ActivityGetInvolvedsResult' => '\\StructType\\ActivityGetInvolvedsResult',
            'ActivityGetProductLines' => '\\StructType\\ActivityGetProductLines',
            'ArrayOfPvProductLineData' => '\\ArrayType\\ArrayOfPvProductLineData',
            'ActivityGetProductLinesResponse' => '\\StructType\\ActivityGetProductLinesResponse',
            'ActivityGetProductLinesResult' => '\\StructType\\ActivityGetProductLinesResult',
            'ActivityGetLines' => '\\StructType\\ActivityGetLines',
            'ArrayOfPvLineData' => '\\ArrayType\\ArrayOfPvLineData',
            'ActivityGetLinesResponse' => '\\StructType\\ActivityGetLinesResponse',
            'ActivityGetLinesResult' => '\\StructType\\ActivityGetLinesResult',
            'RelationExists' => '\\StructType\\RelationExists',
            'RelationExistsResponse' => '\\StructType\\RelationExistsResponse',
            'RelationExistsResult' => '\\StructType\\RelationExistsResult',
            'RelationGetAll' => '\\StructType\\RelationGetAll',
            'ArrayOfPvRelationData' => '\\ArrayType\\ArrayOfPvRelationData',
            'RelationGetAllResponse' => '\\StructType\\RelationGetAllResponse',
            'RelationGetAllResult' => '\\StructType\\RelationGetAllResult',
            'RelationGetModified' => '\\StructType\\RelationGetModified',
            'RelationGetModifiedResponse' => '\\StructType\\RelationGetModifiedResponse',
            'RelationGetModifiedResult' => '\\StructType\\RelationGetModifiedResult',
            'RelationGet' => '\\StructType\\RelationGet',
            'RelationGetResponse' => '\\StructType\\RelationGetResponse',
            'RelationGetResult' => '\\StructType\\RelationGetResult',
            'RelationGetImage' => '\\StructType\\RelationGetImage',
            'RelationGetImageResponse' => '\\StructType\\RelationGetImageResponse',
            'RelationGetImageResult' => '\\StructType\\RelationGetImageResult',
            'RelationGetTelephoneNumbers' => '\\StructType\\RelationGetTelephoneNumbers',
            'PvTelephoneNumberData' => '\\StructType\\PvTelephoneNumberData',
            'ArrayOfPvTelephoneNumberData' => '\\ArrayType\\ArrayOfPvTelephoneNumberData',
            'RelationGetTelephoneNumbersResponse' => '\\StructType\\RelationGetTelephoneNumbersResponse',
            'RelationGetTelephoneNumbersResult' => '\\StructType\\RelationGetTelephoneNumbersResult',
            'RelationSearchByNameAndGetTelephoneNumbers' => '\\StructType\\RelationSearchByNameAndGetTelephoneNumbers',
            'RelationPhoneNumbersType' => '\\StructType\\RelationPhoneNumbersType',
            'ArrayOfRelationPhoneNumbersType' => '\\ArrayType\\ArrayOfRelationPhoneNumbersType',
            'RelationSearchByNameAndGetTelephoneNumbersResponse' => '\\StructType\\RelationSearchByNameAndGetTelephoneNumbersResponse',
            'RelationSearchByNameAndGetPhoneNumbersResult' => '\\StructType\\RelationSearchByNameAndGetPhoneNumbersResult',
            'RelationSearchByField' => '\\StructType\\RelationSearchByField',
            'RelationSearchByFieldResponse' => '\\StructType\\RelationSearchByFieldResponse',
            'RelationSearchByFieldResult' => '\\StructType\\RelationSearchByFieldResult',
            'RelationSearchByFieldExact' => '\\StructType\\RelationSearchByFieldExact',
            'RelationSearchByFieldExactResponse' => '\\StructType\\RelationSearchByFieldExactResponse',
            'RelationSearchByName' => '\\StructType\\RelationSearchByName',
            'RelationSearchByNameResponse' => '\\StructType\\RelationSearchByNameResponse',
            'RelationSearchByNameResult' => '\\StructType\\RelationSearchByNameResult',
            'RelationSearchByName_V2' => '\\StructType\\RelationSearchByName_V2',
            'RelationSearchByName_V2Response' => '\\StructType\\RelationSearchByName_V2Response',
            'RelationSearchByMark' => '\\StructType\\RelationSearchByMark',
            'RelationSearchByMarkResponse' => '\\StructType\\RelationSearchByMarkResponse',
            'RelationSearchByMarkResult' => '\\StructType\\RelationSearchByMarkResult',
            'RelationSearchByTelephone' => '\\StructType\\RelationSearchByTelephone',
            'RelationSearchByTelephoneResponse' => '\\StructType\\RelationSearchByTelephoneResponse',
            'RelationSearchByTelephoneResult' => '\\StructType\\RelationSearchByTelephoneResult',
            'RelationGetParentRelationships' => '\\StructType\\RelationGetParentRelationships',
            'RelationGetParentRelationshipsResponse' => '\\StructType\\RelationGetParentRelationshipsResponse',
            'RelationGetParentRelationshipsResult' => '\\StructType\\RelationGetParentRelationshipsResult',
            'RelationGetChildRelationships' => '\\StructType\\RelationGetChildRelationships',
            'RelationGetChildRelationshipsResponse' => '\\StructType\\RelationGetChildRelationshipsResponse',
            'RelationGetChildRelationshipsResult' => '\\StructType\\RelationGetChildRelationshipsResult',
            'RelationGetChildRelationshipsModified' => '\\StructType\\RelationGetChildRelationshipsModified',
            'RelationGetChildRelationshipsModifiedResponse' => '\\StructType\\RelationGetChildRelationshipsModifiedResponse',
            'RelationGetChildRelationshipsModifiedResult' => '\\StructType\\RelationGetChildRelationshipsModifiedResult',
            'RelationGetActivities' => '\\StructType\\RelationGetActivities',
            'RelationGetActivitiesResponse' => '\\StructType\\RelationGetActivitiesResponse',
            'RelationGetActivitiesResult' => '\\StructType\\RelationGetActivitiesResult',
            'RelationGetActivitiesModified' => '\\StructType\\RelationGetActivitiesModified',
            'RelationGetActivitiesModifiedResponse' => '\\StructType\\RelationGetActivitiesModifiedResponse',
            'RelationGetActivitiesModifiedResult' => '\\StructType\\RelationGetActivitiesModifiedResult',
            'RelationGetActivitiesModified_V2' => '\\StructType\\RelationGetActivitiesModified_V2',
            'RelationGetActivitiesModified_V2Response' => '\\StructType\\RelationGetActivitiesModified_V2Response',
            'RelationGetMarks' => '\\StructType\\RelationGetMarks',
            'ArrayOfPvRelationshipMarkData' => '\\ArrayType\\ArrayOfPvRelationshipMarkData',
            'RelationGetMarksResponse' => '\\StructType\\RelationGetMarksResponse',
            'RelationGetMarksResult' => '\\StructType\\RelationGetMarksResult',
            'RelationGetMarksModified' => '\\StructType\\RelationGetMarksModified',
            'RelationGetMarksModifiedResponse' => '\\StructType\\RelationGetMarksModifiedResponse',
            'RelationGetMarksModifiedResult' => '\\StructType\\RelationGetMarksModifiedResult',
            'RelationGetTelephoneBook' => '\\StructType\\RelationGetTelephoneBook',
            'TelephoneBookEntry' => '\\StructType\\TelephoneBookEntry',
            'ArrayOfTelephoneBookEntry' => '\\ArrayType\\ArrayOfTelephoneBookEntry',
            'RelationGetTelephoneBookResponse' => '\\StructType\\RelationGetTelephoneBookResponse',
            'RelationGetTelephoneBookResult' => '\\StructType\\RelationGetTelephoneBookResult',
            'RelationGetTelephoneBook_V2' => '\\StructType\\RelationGetTelephoneBook_V2',
            'RelationGetTelephoneBook_V2Response' => '\\StructType\\RelationGetTelephoneBook_V2Response',
            'RelationGetAttachments' => '\\StructType\\RelationGetAttachments',
            'RelationGetAttachmentsResponse' => '\\StructType\\RelationGetAttachmentsResponse',
            'RelationGetAttachmentsResult' => '\\StructType\\RelationGetAttachmentsResult',
            'RelationGetNotes' => '\\StructType\\RelationGetNotes',
            'RelationGetNotesResponse' => '\\StructType\\RelationGetNotesResponse',
            'RelationGetNotesResult' => '\\StructType\\RelationGetNotesResult',
            'RelationshipExists' => '\\StructType\\RelationshipExists',
            'RelationshipExistsResponse' => '\\StructType\\RelationshipExistsResponse',
            'RelationshipExistsResult' => '\\StructType\\RelationshipExistsResult',
            'RelationshipGetAll' => '\\StructType\\RelationshipGetAll',
            'RelationshipGetAllResponse' => '\\StructType\\RelationshipGetAllResponse',
            'RelationshipGetAllResult' => '\\StructType\\RelationshipGetAllResult',
            'RelationshipGetModified' => '\\StructType\\RelationshipGetModified',
            'RelationshipGetModifiedResponse' => '\\StructType\\RelationshipGetModifiedResponse',
            'RelationshipGetModifiedResult' => '\\StructType\\RelationshipGetModifiedResult',
            'RelationshipGet' => '\\StructType\\RelationshipGet',
            'RelationshipGetResponse' => '\\StructType\\RelationshipGetResponse',
            'RelationshipGetResult' => '\\StructType\\RelationshipGetResult',
            'RelationshipGetEmployees' => '\\StructType\\RelationshipGetEmployees',
            'RelationshipGetEmployeesResponse' => '\\StructType\\RelationshipGetEmployeesResponse',
            'RelationshipGetEmployeesResult' => '\\StructType\\RelationshipGetEmployeesResult',
            'RelationshipGetEmployeesModified' => '\\StructType\\RelationshipGetEmployeesModified',
            'RelationshipGetEmployeesModifiedResponse' => '\\StructType\\RelationshipGetEmployeesModifiedResponse',
            'RelationshipGetEmployeesModifiedResult' => '\\StructType\\RelationshipGetEmployeesModifiedResult',
            'RelationshipSearchByName' => '\\StructType\\RelationshipSearchByName',
            'RelationshipSearchByNameResponse' => '\\StructType\\RelationshipSearchByNameResponse',
            'RelationshipSearchByNameResult' => '\\StructType\\RelationshipSearchByNameResult',
            'RelationshipSearchByName_V2' => '\\StructType\\RelationshipSearchByName_V2',
            'RelationshipSearchByName_V2Response' => '\\StructType\\RelationshipSearchByName_V2Response',
            'RelationshipSearchByEmail' => '\\StructType\\RelationshipSearchByEmail',
            'RelationshipSearchByEmailResponse' => '\\StructType\\RelationshipSearchByEmailResponse',
            'RelationshipSearchByEmailResult' => '\\StructType\\RelationshipSearchByEmailResult',
            'RelationshipSearchByField' => '\\StructType\\RelationshipSearchByField',
            'RelationshipSearchByFieldResponse' => '\\StructType\\RelationshipSearchByFieldResponse',
            'RelationshipSearchByFieldResult' => '\\StructType\\RelationshipSearchByFieldResult',
            'RelationshipSearchByMark' => '\\StructType\\RelationshipSearchByMark',
            'RelationshipSearchByMarkResponse' => '\\StructType\\RelationshipSearchByMarkResponse',
            'RelationshipSearchByMarkResult' => '\\StructType\\RelationshipSearchByMarkResult',
            'RelationshipSearchByMarkAndDate' => '\\StructType\\RelationshipSearchByMarkAndDate',
            'RelationshipSearchByMarkAndDateResponse' => '\\StructType\\RelationshipSearchByMarkAndDateResponse',
            'RelationshipGetMarks' => '\\StructType\\RelationshipGetMarks',
            'RelationshipGetMarksResponse' => '\\StructType\\RelationshipGetMarksResponse',
            'RelationshipGetMarksResult' => '\\StructType\\RelationshipGetMarksResult',
            'RelationshipGetMarksCompact' => '\\StructType\\RelationshipGetMarksCompact',
            'PvRelationshipMarkDataCompact' => '\\StructType\\PvRelationshipMarkDataCompact',
            'ArrayOfPvRelationshipMarkDataCompact' => '\\ArrayType\\ArrayOfPvRelationshipMarkDataCompact',
            'RelationshipGetMarksCompactResponse' => '\\StructType\\RelationshipGetMarksCompactResponse',
            'RelationshipGetMarksCompactResult' => '\\StructType\\RelationshipGetMarksCompactResult',
            'RelationshipGetLines' => '\\StructType\\RelationshipGetLines',
            'RelationshipGetLinesResponse' => '\\StructType\\RelationshipGetLinesResponse',
            'RelationshipGetLinesResult' => '\\StructType\\RelationshipGetLinesResult',
            'ProductGroupExists' => '\\StructType\\ProductGroupExists',
            'ProductGroupExistsResponse' => '\\StructType\\ProductGroupExistsResponse',
            'ProductGroupExistsResult' => '\\StructType\\ProductGroupExistsResult',
            'ProductGroupGet' => '\\StructType\\ProductGroupGet',
            'ProductGroupGetResponse' => '\\StructType\\ProductGroupGetResponse',
            'ProductGroupGetResult' => '\\StructType\\ProductGroupGetResult',
            'ProductGroupGetAll' => '\\StructType\\ProductGroupGetAll',
            'ArrayOfPvProductGroupData' => '\\ArrayType\\ArrayOfPvProductGroupData',
            'ProductGroupGetAllResponse' => '\\StructType\\ProductGroupGetAllResponse',
            'ProductGroupGetAllResult' => '\\StructType\\ProductGroupGetAllResult',
            'ProductExists' => '\\StructType\\ProductExists',
            'ProductExistsResponse' => '\\StructType\\ProductExistsResponse',
            'ProductExistsResult' => '\\StructType\\ProductExistsResult',
            'ProductSearchByFieldExact' => '\\StructType\\ProductSearchByFieldExact',
            'ArrayOfPvProductData' => '\\ArrayType\\ArrayOfPvProductData',
            'ProductSearchByFieldExactResponse' => '\\StructType\\ProductSearchByFieldExactResponse',
            'ProductSearchByFieldExactResult' => '\\StructType\\ProductSearchByFieldExactResult',
            'ProductGet' => '\\StructType\\ProductGet',
            'ProductGetResponse' => '\\StructType\\ProductGetResponse',
            'ProductGetResult' => '\\StructType\\ProductGetResult',
            'ProductGet_V2' => '\\StructType\\ProductGet_V2',
            'ProductGet_V2Response' => '\\StructType\\ProductGet_V2Response',
            'ProductGetResult_V2' => '\\StructType\\ProductGetResult_V2',
            'ProductGetAll' => '\\StructType\\ProductGetAll',
            'ProductGetAllResponse' => '\\StructType\\ProductGetAllResponse',
            'ProductGetAllResult' => '\\StructType\\ProductGetAllResult',
            'ProductGetAll_V2' => '\\StructType\\ProductGetAll_V2',
            'ArrayOfPvProductData_V2' => '\\ArrayType\\ArrayOfPvProductData_V2',
            'ProductGetAll_V2Response' => '\\StructType\\ProductGetAll_V2Response',
            'ProductGetAllResult_V2' => '\\StructType\\ProductGetAllResult_V2',
            'ProductGetAllByGroup' => '\\StructType\\ProductGetAllByGroup',
            'ProductGetAllByGroupResponse' => '\\StructType\\ProductGetAllByGroupResponse',
            'ProductGetAllByGroupResult' => '\\StructType\\ProductGetAllByGroupResult',
            'ProductGetAllByGroup_V2' => '\\StructType\\ProductGetAllByGroup_V2',
            'ProductGetAllByGroup_V2Response' => '\\StructType\\ProductGetAllByGroup_V2Response',
            'ProductGetAllByGroupResult_V2' => '\\StructType\\ProductGetAllByGroupResult_V2',
            'ProductLineGet' => '\\StructType\\ProductLineGet',
            'ProductLineGetResponse' => '\\StructType\\ProductLineGetResponse',
            'ProductLineGetResult' => '\\StructType\\ProductLineGetResult',
            'AttachmentExists' => '\\StructType\\AttachmentExists',
            'AttachmentExistsResponse' => '\\StructType\\AttachmentExistsResponse',
            'AttachmentExistsResult' => '\\StructType\\AttachmentExistsResult',
            'AttachmentGet' => '\\StructType\\AttachmentGet',
            'AttachmentGetResponse' => '\\StructType\\AttachmentGetResponse',
            'AttachmentGetResult' => '\\StructType\\AttachmentGetResult',
            'AttachmentGetGoogleDocsUrl' => '\\StructType\\AttachmentGetGoogleDocsUrl',
            'AttachmentGetGoogleDocsUrlResponse' => '\\StructType\\AttachmentGetGoogleDocsUrlResponse',
            'AttachmentGetGoogleDocsUrlResult' => '\\StructType\\AttachmentGetGoogleDocsUrlResult',
            'DatastoreGetItems' => '\\StructType\\DatastoreGetItems',
            'DatastoreGetItemsResponse' => '\\StructType\\DatastoreGetItemsResponse',
            'DatastoreGetItemsResult' => '\\StructType\\DatastoreGetItemsResult',
            'DatastoreGetItems_V2' => '\\StructType\\DatastoreGetItems_V2',
            'ArrayOfPvDatastoreItemData_V2' => '\\ArrayType\\ArrayOfPvDatastoreItemData_V2',
            'DatastoreGetItems_V2Response' => '\\StructType\\DatastoreGetItems_V2Response',
            'DatastoreGetItemsResult_V2' => '\\StructType\\DatastoreGetItemsResult_V2',
            'DatastoreGetItems_V3' => '\\StructType\\DatastoreGetItems_V3',
            'ArrayOfPvDatastoreItemData_V3' => '\\ArrayType\\ArrayOfPvDatastoreItemData_V3',
            'DatastoreGetItems_V3Response' => '\\StructType\\DatastoreGetItems_V3Response',
            'DatastoreGetItemsResult_V3' => '\\StructType\\DatastoreGetItemsResult_V3',
            'DatastoreGetWithParentItems' => '\\StructType\\DatastoreGetWithParentItems',
            'PvDatastoreItemDataWithParent' => '\\StructType\\PvDatastoreItemDataWithParent',
            'ArrayOfPvDatastoreItemDataWithParent' => '\\ArrayType\\ArrayOfPvDatastoreItemDataWithParent',
            'DatastoreGetWithParentItemsResponse' => '\\StructType\\DatastoreGetWithParentItemsResponse',
            'DatastoreGetWithParentItemsResult' => '\\StructType\\DatastoreGetWithParentItemsResult',
            'DatastoreGetWithParentItems_V2' => '\\StructType\\DatastoreGetWithParentItems_V2',
            'PvDatastoreItemDataWithParent_V2' => '\\StructType\\PvDatastoreItemDataWithParent_V2',
            'ArrayOfPvDatastoreItemDataWithParent_V2' => '\\ArrayType\\ArrayOfPvDatastoreItemDataWithParent_V2',
            'DatastoreGetWithParentItems_V2Response' => '\\StructType\\DatastoreGetWithParentItems_V2Response',
            'DatastoreGetWithParentItemsResult_V2' => '\\StructType\\DatastoreGetWithParentItemsResult_V2',
            'DatastoreGetCountries' => '\\StructType\\DatastoreGetCountries',
            'PvCountryData' => '\\StructType\\PvCountryData',
            'ArrayOfPvCountryData' => '\\ArrayType\\ArrayOfPvCountryData',
            'DatastoreGetCountriesResponse' => '\\StructType\\DatastoreGetCountriesResponse',
            'DatastoreGetCountriesResult' => '\\StructType\\DatastoreGetCountriesResult',
            'DatastoreGetSbiCodes' => '\\StructType\\DatastoreGetSbiCodes',
            'PvSbiCodeData' => '\\StructType\\PvSbiCodeData',
            'ArrayOfPvSbiCodeData' => '\\ArrayType\\ArrayOfPvSbiCodeData',
            'DatastoreGetSbiCodesResponse' => '\\StructType\\DatastoreGetSbiCodesResponse',
            'DatastoreGetSbiCodesResult' => '\\StructType\\DatastoreGetSbiCodesResult',
            'SystemDatastoreGetItems' => '\\StructType\\SystemDatastoreGetItems',
            'PvSystemDatastoreItemData' => '\\StructType\\PvSystemDatastoreItemData',
            'ArrayOfPvSystemDatastoreItemData' => '\\ArrayType\\ArrayOfPvSystemDatastoreItemData',
            'SystemDatastoreGetItemsResponse' => '\\StructType\\SystemDatastoreGetItemsResponse',
            'SystemDatastoreGetItemsResult' => '\\StructType\\SystemDatastoreGetItemsResult',
            'NotificationGetCount' => '\\StructType\\NotificationGetCount',
            'NotificationGetCountResponse' => '\\StructType\\NotificationGetCountResponse',
            'NotificationGetCountResult' => '\\StructType\\NotificationGetCountResult',
            'NotificationsGet' => '\\StructType\\NotificationsGet',
            'PvNotificationData' => '\\StructType\\PvNotificationData',
            'ArrayOfPvNotificationData' => '\\ArrayType\\ArrayOfPvNotificationData',
            'NotificationsGetResponse' => '\\StructType\\NotificationsGetResponse',
            'NotificationsGetResult' => '\\StructType\\NotificationsGetResult',
            'NoteExists' => '\\StructType\\NoteExists',
            'NoteExistsResponse' => '\\StructType\\NoteExistsResponse',
            'NoteExistsResult' => '\\StructType\\NoteExistsResult',
        );
    }
}
