<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvTelephoneNumberData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvTelephoneNumberData extends AbstractStructArrayBase
{
    /**
     * The PvTelephoneNumberData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvTelephoneNumberData[]
     */
    public $PvTelephoneNumberData;
    /**
     * Constructor method for ArrayOfPvTelephoneNumberData
     * @uses ArrayOfPvTelephoneNumberData::setPvTelephoneNumberData()
     * @param \StructType\PvTelephoneNumberData[] $pvTelephoneNumberData
     */
    public function __construct(array $pvTelephoneNumberData = array())
    {
        $this
            ->setPvTelephoneNumberData($pvTelephoneNumberData);
    }
    /**
     * Get PvTelephoneNumberData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvTelephoneNumberData[]|null
     */
    public function getPvTelephoneNumberData()
    {
        return isset($this->PvTelephoneNumberData) ? $this->PvTelephoneNumberData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvTelephoneNumberData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvTelephoneNumberData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvTelephoneNumberDataForArrayConstraintsFromSetPvTelephoneNumberData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvTelephoneNumberDataPvTelephoneNumberDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvTelephoneNumberDataPvTelephoneNumberDataItem instanceof \StructType\PvTelephoneNumberData) {
                $invalidValues[] = is_object($arrayOfPvTelephoneNumberDataPvTelephoneNumberDataItem) ? get_class($arrayOfPvTelephoneNumberDataPvTelephoneNumberDataItem) : sprintf('%s(%s)', gettype($arrayOfPvTelephoneNumberDataPvTelephoneNumberDataItem), var_export($arrayOfPvTelephoneNumberDataPvTelephoneNumberDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvTelephoneNumberData property can only contain items of type \StructType\PvTelephoneNumberData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvTelephoneNumberData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvTelephoneNumberData[] $pvTelephoneNumberData
     * @return \ArrayType\ArrayOfPvTelephoneNumberData
     */
    public function setPvTelephoneNumberData(array $pvTelephoneNumberData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvTelephoneNumberDataArrayErrorMessage = self::validatePvTelephoneNumberDataForArrayConstraintsFromSetPvTelephoneNumberData($pvTelephoneNumberData))) {
            throw new \InvalidArgumentException($pvTelephoneNumberDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvTelephoneNumberData) || (is_array($pvTelephoneNumberData) && empty($pvTelephoneNumberData))) {
            unset($this->PvTelephoneNumberData);
        } else {
            $this->PvTelephoneNumberData = $pvTelephoneNumberData;
        }
        return $this;
    }
    /**
     * Add item to PvTelephoneNumberData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvTelephoneNumberData $item
     * @return \ArrayType\ArrayOfPvTelephoneNumberData
     */
    public function addToPvTelephoneNumberData(\StructType\PvTelephoneNumberData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvTelephoneNumberData) {
            throw new \InvalidArgumentException(sprintf('The PvTelephoneNumberData property can only contain items of type \StructType\PvTelephoneNumberData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvTelephoneNumberData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvTelephoneNumberData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvTelephoneNumberData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvTelephoneNumberData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvTelephoneNumberData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvTelephoneNumberData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvTelephoneNumberData
     */
    public function getAttributeName()
    {
        return 'PvTelephoneNumberData';
    }
}
