<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvRelationData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvRelationData extends AbstractStructArrayBase
{
    /**
     * The PvRelationData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvRelationData[]
     */
    public $PvRelationData;
    /**
     * Constructor method for ArrayOfPvRelationData
     * @uses ArrayOfPvRelationData::setPvRelationData()
     * @param \StructType\PvRelationData[] $pvRelationData
     */
    public function __construct(array $pvRelationData = array())
    {
        $this
            ->setPvRelationData($pvRelationData);
    }
    /**
     * Get PvRelationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvRelationData[]|null
     */
    public function getPvRelationData()
    {
        return isset($this->PvRelationData) ? $this->PvRelationData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvRelationData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvRelationData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvRelationDataForArrayConstraintsFromSetPvRelationData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvRelationDataPvRelationDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvRelationDataPvRelationDataItem instanceof \StructType\PvRelationData) {
                $invalidValues[] = is_object($arrayOfPvRelationDataPvRelationDataItem) ? get_class($arrayOfPvRelationDataPvRelationDataItem) : sprintf('%s(%s)', gettype($arrayOfPvRelationDataPvRelationDataItem), var_export($arrayOfPvRelationDataPvRelationDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvRelationData property can only contain items of type \StructType\PvRelationData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvRelationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvRelationData[] $pvRelationData
     * @return \ArrayType\ArrayOfPvRelationData
     */
    public function setPvRelationData(array $pvRelationData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvRelationDataArrayErrorMessage = self::validatePvRelationDataForArrayConstraintsFromSetPvRelationData($pvRelationData))) {
            throw new \InvalidArgumentException($pvRelationDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvRelationData) || (is_array($pvRelationData) && empty($pvRelationData))) {
            unset($this->PvRelationData);
        } else {
            $this->PvRelationData = $pvRelationData;
        }
        return $this;
    }
    /**
     * Add item to PvRelationData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvRelationData $item
     * @return \ArrayType\ArrayOfPvRelationData
     */
    public function addToPvRelationData(\StructType\PvRelationData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvRelationData) {
            throw new \InvalidArgumentException(sprintf('The PvRelationData property can only contain items of type \StructType\PvRelationData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvRelationData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvRelationData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvRelationData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvRelationData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvRelationData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvRelationData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvRelationData
     */
    public function getAttributeName()
    {
        return 'PvRelationData';
    }
}
