<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvProductData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvProductData extends AbstractStructArrayBase
{
    /**
     * The PvProductData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvProductData[]
     */
    public $PvProductData;
    /**
     * Constructor method for ArrayOfPvProductData
     * @uses ArrayOfPvProductData::setPvProductData()
     * @param \StructType\PvProductData[] $pvProductData
     */
    public function __construct(array $pvProductData = array())
    {
        $this
            ->setPvProductData($pvProductData);
    }
    /**
     * Get PvProductData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvProductData[]|null
     */
    public function getPvProductData()
    {
        return isset($this->PvProductData) ? $this->PvProductData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvProductData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvProductData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvProductDataForArrayConstraintsFromSetPvProductData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvProductDataPvProductDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvProductDataPvProductDataItem instanceof \StructType\PvProductData) {
                $invalidValues[] = is_object($arrayOfPvProductDataPvProductDataItem) ? get_class($arrayOfPvProductDataPvProductDataItem) : sprintf('%s(%s)', gettype($arrayOfPvProductDataPvProductDataItem), var_export($arrayOfPvProductDataPvProductDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvProductData property can only contain items of type \StructType\PvProductData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvProductData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvProductData[] $pvProductData
     * @return \ArrayType\ArrayOfPvProductData
     */
    public function setPvProductData(array $pvProductData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvProductDataArrayErrorMessage = self::validatePvProductDataForArrayConstraintsFromSetPvProductData($pvProductData))) {
            throw new \InvalidArgumentException($pvProductDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvProductData) || (is_array($pvProductData) && empty($pvProductData))) {
            unset($this->PvProductData);
        } else {
            $this->PvProductData = $pvProductData;
        }
        return $this;
    }
    /**
     * Add item to PvProductData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvProductData $item
     * @return \ArrayType\ArrayOfPvProductData
     */
    public function addToPvProductData(\StructType\PvProductData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvProductData) {
            throw new \InvalidArgumentException(sprintf('The PvProductData property can only contain items of type \StructType\PvProductData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvProductData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvProductData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvProductData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvProductData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvProductData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvProductData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvProductData
     */
    public function getAttributeName()
    {
        return 'PvProductData';
    }
}
