<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvInvolvedData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvInvolvedData extends AbstractStructArrayBase
{
    /**
     * The PvInvolvedData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvInvolvedData[]
     */
    public $PvInvolvedData;
    /**
     * Constructor method for ArrayOfPvInvolvedData
     * @uses ArrayOfPvInvolvedData::setPvInvolvedData()
     * @param \StructType\PvInvolvedData[] $pvInvolvedData
     */
    public function __construct(array $pvInvolvedData = array())
    {
        $this
            ->setPvInvolvedData($pvInvolvedData);
    }
    /**
     * Get PvInvolvedData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvInvolvedData[]|null
     */
    public function getPvInvolvedData()
    {
        return isset($this->PvInvolvedData) ? $this->PvInvolvedData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvInvolvedData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvInvolvedData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvInvolvedDataForArrayConstraintsFromSetPvInvolvedData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvInvolvedDataPvInvolvedDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvInvolvedDataPvInvolvedDataItem instanceof \StructType\PvInvolvedData) {
                $invalidValues[] = is_object($arrayOfPvInvolvedDataPvInvolvedDataItem) ? get_class($arrayOfPvInvolvedDataPvInvolvedDataItem) : sprintf('%s(%s)', gettype($arrayOfPvInvolvedDataPvInvolvedDataItem), var_export($arrayOfPvInvolvedDataPvInvolvedDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvInvolvedData property can only contain items of type \StructType\PvInvolvedData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvInvolvedData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvInvolvedData[] $pvInvolvedData
     * @return \ArrayType\ArrayOfPvInvolvedData
     */
    public function setPvInvolvedData(array $pvInvolvedData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvInvolvedDataArrayErrorMessage = self::validatePvInvolvedDataForArrayConstraintsFromSetPvInvolvedData($pvInvolvedData))) {
            throw new \InvalidArgumentException($pvInvolvedDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvInvolvedData) || (is_array($pvInvolvedData) && empty($pvInvolvedData))) {
            unset($this->PvInvolvedData);
        } else {
            $this->PvInvolvedData = $pvInvolvedData;
        }
        return $this;
    }
    /**
     * Add item to PvInvolvedData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvInvolvedData $item
     * @return \ArrayType\ArrayOfPvInvolvedData
     */
    public function addToPvInvolvedData(\StructType\PvInvolvedData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvInvolvedData) {
            throw new \InvalidArgumentException(sprintf('The PvInvolvedData property can only contain items of type \StructType\PvInvolvedData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvInvolvedData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvInvolvedData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvInvolvedData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvInvolvedData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvInvolvedData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvInvolvedData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvInvolvedData
     */
    public function getAttributeName()
    {
        return 'PvInvolvedData';
    }
}
