<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvCounterData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvCounterData extends AbstractStructArrayBase
{
    /**
     * The PvCounterData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvCounterData[]
     */
    public $PvCounterData;
    /**
     * Constructor method for ArrayOfPvCounterData
     * @uses ArrayOfPvCounterData::setPvCounterData()
     * @param \StructType\PvCounterData[] $pvCounterData
     */
    public function __construct(array $pvCounterData = array())
    {
        $this
            ->setPvCounterData($pvCounterData);
    }
    /**
     * Get PvCounterData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvCounterData[]|null
     */
    public function getPvCounterData()
    {
        return isset($this->PvCounterData) ? $this->PvCounterData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvCounterData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvCounterData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvCounterDataForArrayConstraintsFromSetPvCounterData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvCounterDataPvCounterDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvCounterDataPvCounterDataItem instanceof \StructType\PvCounterData) {
                $invalidValues[] = is_object($arrayOfPvCounterDataPvCounterDataItem) ? get_class($arrayOfPvCounterDataPvCounterDataItem) : sprintf('%s(%s)', gettype($arrayOfPvCounterDataPvCounterDataItem), var_export($arrayOfPvCounterDataPvCounterDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvCounterData property can only contain items of type \StructType\PvCounterData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvCounterData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvCounterData[] $pvCounterData
     * @return \ArrayType\ArrayOfPvCounterData
     */
    public function setPvCounterData(array $pvCounterData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvCounterDataArrayErrorMessage = self::validatePvCounterDataForArrayConstraintsFromSetPvCounterData($pvCounterData))) {
            throw new \InvalidArgumentException($pvCounterDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvCounterData) || (is_array($pvCounterData) && empty($pvCounterData))) {
            unset($this->PvCounterData);
        } else {
            $this->PvCounterData = $pvCounterData;
        }
        return $this;
    }
    /**
     * Add item to PvCounterData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvCounterData $item
     * @return \ArrayType\ArrayOfPvCounterData
     */
    public function addToPvCounterData(\StructType\PvCounterData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvCounterData) {
            throw new \InvalidArgumentException(sprintf('The PvCounterData property can only contain items of type \StructType\PvCounterData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvCounterData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvCounterData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvCounterData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvCounterData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvCounterData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvCounterData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvCounterData
     */
    public function getAttributeName()
    {
        return 'PvCounterData';
    }
}
