<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvAttachmentData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvAttachmentData extends AbstractStructArrayBase
{
    /**
     * The PvAttachmentData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvAttachmentData[]
     */
    public $PvAttachmentData;
    /**
     * Constructor method for ArrayOfPvAttachmentData
     * @uses ArrayOfPvAttachmentData::setPvAttachmentData()
     * @param \StructType\PvAttachmentData[] $pvAttachmentData
     */
    public function __construct(array $pvAttachmentData = array())
    {
        $this
            ->setPvAttachmentData($pvAttachmentData);
    }
    /**
     * Get PvAttachmentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvAttachmentData[]|null
     */
    public function getPvAttachmentData()
    {
        return isset($this->PvAttachmentData) ? $this->PvAttachmentData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvAttachmentData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvAttachmentData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvAttachmentDataForArrayConstraintsFromSetPvAttachmentData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvAttachmentDataPvAttachmentDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvAttachmentDataPvAttachmentDataItem instanceof \StructType\PvAttachmentData) {
                $invalidValues[] = is_object($arrayOfPvAttachmentDataPvAttachmentDataItem) ? get_class($arrayOfPvAttachmentDataPvAttachmentDataItem) : sprintf('%s(%s)', gettype($arrayOfPvAttachmentDataPvAttachmentDataItem), var_export($arrayOfPvAttachmentDataPvAttachmentDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvAttachmentData property can only contain items of type \StructType\PvAttachmentData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvAttachmentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvAttachmentData[] $pvAttachmentData
     * @return \ArrayType\ArrayOfPvAttachmentData
     */
    public function setPvAttachmentData(array $pvAttachmentData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvAttachmentDataArrayErrorMessage = self::validatePvAttachmentDataForArrayConstraintsFromSetPvAttachmentData($pvAttachmentData))) {
            throw new \InvalidArgumentException($pvAttachmentDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvAttachmentData) || (is_array($pvAttachmentData) && empty($pvAttachmentData))) {
            unset($this->PvAttachmentData);
        } else {
            $this->PvAttachmentData = $pvAttachmentData;
        }
        return $this;
    }
    /**
     * Add item to PvAttachmentData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvAttachmentData $item
     * @return \ArrayType\ArrayOfPvAttachmentData
     */
    public function addToPvAttachmentData(\StructType\PvAttachmentData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvAttachmentData) {
            throw new \InvalidArgumentException(sprintf('The PvAttachmentData property can only contain items of type \StructType\PvAttachmentData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvAttachmentData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvAttachmentData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvAttachmentData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvAttachmentData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvAttachmentData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvAttachmentData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvAttachmentData
     */
    public function getAttributeName()
    {
        return 'PvAttachmentData';
    }
}
