<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfParameter ArrayType
 * @subpackage Arrays
 */
class ArrayOfParameter extends AbstractStructArrayBase
{
    /**
     * The Parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Parameter[]
     */
    public $Parameter;
    /**
     * Constructor method for ArrayOfParameter
     * @uses ArrayOfParameter::setParameter()
     * @param \StructType\Parameter[] $parameter
     */
    public function __construct(array $parameter = array())
    {
        $this
            ->setParameter($parameter);
    }
    /**
     * Get Parameter value
     * @return \StructType\Parameter[]|null
     */
    public function getParameter()
    {
        return $this->Parameter;
    }
    /**
     * This method is responsible for validating the values passed to the setParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParameterForArrayConstraintsFromSetParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfParameterParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfParameterParameterItem instanceof \StructType\Parameter) {
                $invalidValues[] = is_object($arrayOfParameterParameterItem) ? get_class($arrayOfParameterParameterItem) : sprintf('%s(%s)', gettype($arrayOfParameterParameterItem), var_export($arrayOfParameterParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameter property can only contain items of type \StructType\Parameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\Parameter[] $parameter
     * @return \ArrayType\ArrayOfParameter
     */
    public function setParameter(array $parameter = array())
    {
        // validation for constraint: array
        if ('' !== ($parameterArrayErrorMessage = self::validateParameterForArrayConstraintsFromSetParameter($parameter))) {
            throw new \InvalidArgumentException($parameterArrayErrorMessage, __LINE__);
        }
        $this->Parameter = $parameter;
        return $this;
    }
    /**
     * Add item to Parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\Parameter $item
     * @return \ArrayType\ArrayOfParameter
     */
    public function addToParameter(\StructType\Parameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Parameter) {
            throw new \InvalidArgumentException(sprintf('The Parameter property can only contain items of type \StructType\Parameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parameter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Parameter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Parameter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Parameter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Parameter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Parameter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Parameter
     */
    public function getAttributeName()
    {
        return 'Parameter';
    }
}
