<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityParameter ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityParameter extends AbstractStructArrayBase
{
    /**
     * The ActivityParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActivityParameter[]
     */
    public $ActivityParameter;
    /**
     * Constructor method for ArrayOfActivityParameter
     * @uses ArrayOfActivityParameter::setActivityParameter()
     * @param \StructType\ActivityParameter[] $activityParameter
     */
    public function __construct(array $activityParameter = array())
    {
        $this
            ->setActivityParameter($activityParameter);
    }
    /**
     * Get ActivityParameter value
     * @return \StructType\ActivityParameter[]|null
     */
    public function getActivityParameter()
    {
        return $this->ActivityParameter;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityParameterForArrayConstraintsFromSetActivityParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityParameterActivityParameterItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityParameterActivityParameterItem instanceof \StructType\ActivityParameter) {
                $invalidValues[] = is_object($arrayOfActivityParameterActivityParameterItem) ? get_class($arrayOfActivityParameterActivityParameterItem) : sprintf('%s(%s)', gettype($arrayOfActivityParameterActivityParameterItem), var_export($arrayOfActivityParameterActivityParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityParameter property can only contain items of type \StructType\ActivityParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityParameter[] $activityParameter
     * @return \ArrayType\ArrayOfActivityParameter
     */
    public function setActivityParameter(array $activityParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($activityParameterArrayErrorMessage = self::validateActivityParameterForArrayConstraintsFromSetActivityParameter($activityParameter))) {
            throw new \InvalidArgumentException($activityParameterArrayErrorMessage, __LINE__);
        }
        $this->ActivityParameter = $activityParameter;
        return $this;
    }
    /**
     * Add item to ActivityParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityParameter $item
     * @return \ArrayType\ArrayOfActivityParameter
     */
    public function addToActivityParameter(\StructType\ActivityParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityParameter) {
            throw new \InvalidArgumentException(sprintf('The ActivityParameter property can only contain items of type \StructType\ActivityParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityParameter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityParameter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityParameter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityParameter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityParameter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityParameter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityParameter
     */
    public function getAttributeName()
    {
        return 'ActivityParameter';
    }
}
