<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkflowStepGetAll StructType
 * @subpackage Structs
 */
class WorkflowStepGetAll extends AbstractStructBase
{
    /**
     * The workflowId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $workflowId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for WorkflowStepGetAll
     * @uses WorkflowStepGetAll::setWorkflowId()
     * @uses WorkflowStepGetAll::setCredentials()
     * @param string $workflowId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($workflowId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setWorkflowId($workflowId)
            ->setCredentials($credentials);
    }
    /**
     * Get workflowId value
     * @return string
     */
    public function getWorkflowId()
    {
        return $this->workflowId;
    }
    /**
     * Set workflowId value
     * @param string $workflowId
     * @return \StructType\WorkflowStepGetAll
     */
    public function setWorkflowId($workflowId = null)
    {
        // validation for constraint: string
        if (!is_null($workflowId) && !is_string($workflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowId, true), gettype($workflowId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($workflowId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $workflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($workflowId, true)), __LINE__);
        }
        $this->workflowId = $workflowId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\WorkflowStepGetAll
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
