<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsersSetLanguage StructType
 * @subpackage Structs
 */
class UsersSetLanguage extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $userId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The cultureCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cultureCode;
    /**
     * Constructor method for UsersSetLanguage
     * @uses UsersSetLanguage::setUserId()
     * @uses UsersSetLanguage::setCredentials()
     * @uses UsersSetLanguage::setCultureCode()
     * @param string $userId
     * @param \StructType\ApiCredentials $credentials
     * @param string $cultureCode
     */
    public function __construct($userId = null, \StructType\ApiCredentials $credentials = null, $cultureCode = null)
    {
        $this
            ->setUserId($userId)
            ->setCredentials($credentials)
            ->setCultureCode($cultureCode);
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\UsersSetLanguage
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\UsersSetLanguage
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get cultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->cultureCode;
    }
    /**
     * Set cultureCode value
     * @param string $cultureCode
     * @return \StructType\UsersSetLanguage
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureCode, true), gettype($cultureCode)), __LINE__);
        }
        $this->cultureCode = $cultureCode;
        return $this;
    }
}
