<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionUpdate StructType
 * @subpackage Structs
 */
class SubscriptionUpdate extends AbstractStructBase
{
    /**
     * The activityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $activityId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The followUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityFollowUpData
     */
    public $followUp;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * Constructor method for SubscriptionUpdate
     * @uses SubscriptionUpdate::setActivityId()
     * @uses SubscriptionUpdate::setCredentials()
     * @uses SubscriptionUpdate::setFollowUp()
     * @uses SubscriptionUpdate::setFieldValues()
     * @param string $activityId
     * @param \StructType\ApiCredentials $credentials
     * @param \StructType\PvActivityFollowUpData $followUp
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     */
    public function __construct($activityId = null, \StructType\ApiCredentials $credentials = null, \StructType\PvActivityFollowUpData $followUp = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this
            ->setActivityId($activityId)
            ->setCredentials($credentials)
            ->setFollowUp($followUp)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get activityId value
     * @return string
     */
    public function getActivityId()
    {
        return $this->activityId;
    }
    /**
     * Set activityId value
     * @param string $activityId
     * @return \StructType\SubscriptionUpdate
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        $this->activityId = $activityId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\SubscriptionUpdate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get followUp value
     * @return \StructType\PvActivityFollowUpData|null
     */
    public function getFollowUp()
    {
        return $this->followUp;
    }
    /**
     * Set followUp value
     * @param \StructType\PvActivityFollowUpData $followUp
     * @return \StructType\SubscriptionUpdate
     */
    public function setFollowUp(\StructType\PvActivityFollowUpData $followUp = null)
    {
        $this->followUp = $followUp;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\SubscriptionUpdate
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
}
