<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionCreate StructType
 * @subpackage Structs
 */
class SubscriptionCreate extends AbstractStructBase
{
    /**
     * The connectToActivityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $connectToActivityId;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $productId;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $quantity;
    /**
     * The vatId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $vatId;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $amount;
    /**
     * The purchaseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $purchaseAmount;
    /**
     * The period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $period;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The settings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivitySettingsData
     */
    public $settings;
    /**
     * The followUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityFollowUpData
     */
    public $followUp;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for SubscriptionCreate
     * @uses SubscriptionCreate::setConnectToActivityId()
     * @uses SubscriptionCreate::setProductId()
     * @uses SubscriptionCreate::setQuantity()
     * @uses SubscriptionCreate::setVatId()
     * @uses SubscriptionCreate::setAmount()
     * @uses SubscriptionCreate::setPurchaseAmount()
     * @uses SubscriptionCreate::setPeriod()
     * @uses SubscriptionCreate::setCredentials()
     * @uses SubscriptionCreate::setSettings()
     * @uses SubscriptionCreate::setFollowUp()
     * @uses SubscriptionCreate::setFieldValues()
     * @uses SubscriptionCreate::setDescription()
     * @param string $connectToActivityId
     * @param string $productId
     * @param float $quantity
     * @param string $vatId
     * @param float $amount
     * @param float $purchaseAmount
     * @param int $period
     * @param \StructType\ApiCredentials $credentials
     * @param \StructType\PvActivitySettingsData $settings
     * @param \StructType\PvActivityFollowUpData $followUp
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @param string $description
     */
    public function __construct($connectToActivityId = null, $productId = null, $quantity = null, $vatId = null, $amount = null, $purchaseAmount = null, $period = null, \StructType\ApiCredentials $credentials = null, \StructType\PvActivitySettingsData $settings = null, \StructType\PvActivityFollowUpData $followUp = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null, $description = null)
    {
        $this
            ->setConnectToActivityId($connectToActivityId)
            ->setProductId($productId)
            ->setQuantity($quantity)
            ->setVatId($vatId)
            ->setAmount($amount)
            ->setPurchaseAmount($purchaseAmount)
            ->setPeriod($period)
            ->setCredentials($credentials)
            ->setSettings($settings)
            ->setFollowUp($followUp)
            ->setFieldValues($fieldValues)
            ->setDescription($description);
    }
    /**
     * Get connectToActivityId value
     * @return string
     */
    public function getConnectToActivityId()
    {
        return $this->connectToActivityId;
    }
    /**
     * Set connectToActivityId value
     * @param string $connectToActivityId
     * @return \StructType\SubscriptionCreate
     */
    public function setConnectToActivityId($connectToActivityId = null)
    {
        // validation for constraint: string
        if (!is_null($connectToActivityId) && !is_string($connectToActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectToActivityId, true), gettype($connectToActivityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($connectToActivityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $connectToActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($connectToActivityId, true)), __LINE__);
        }
        $this->connectToActivityId = $connectToActivityId;
        return $this;
    }
    /**
     * Get productId value
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\SubscriptionCreate
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\SubscriptionCreate
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get vatId value
     * @return string
     */
    public function getVatId()
    {
        return $this->vatId;
    }
    /**
     * Set vatId value
     * @param string $vatId
     * @return \StructType\SubscriptionCreate
     */
    public function setVatId($vatId = null)
    {
        // validation for constraint: string
        if (!is_null($vatId) && !is_string($vatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatId, true), gettype($vatId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($vatId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $vatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($vatId, true)), __LINE__);
        }
        $this->vatId = $vatId;
        return $this;
    }
    /**
     * Get amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\SubscriptionCreate
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get purchaseAmount value
     * @return float
     */
    public function getPurchaseAmount()
    {
        return $this->purchaseAmount;
    }
    /**
     * Set purchaseAmount value
     * @param float $purchaseAmount
     * @return \StructType\SubscriptionCreate
     */
    public function setPurchaseAmount($purchaseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseAmount) && !(is_float($purchaseAmount) || is_numeric($purchaseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseAmount, true), gettype($purchaseAmount)), __LINE__);
        }
        $this->purchaseAmount = $purchaseAmount;
        return $this;
    }
    /**
     * Get period value
     * @return int
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param int $period
     * @return \StructType\SubscriptionCreate
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: int
        if (!is_null($period) && !(is_int($period) || ctype_digit($period))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($period, true), gettype($period)), __LINE__);
        }
        $this->period = $period;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\SubscriptionCreate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get settings value
     * @return \StructType\PvActivitySettingsData|null
     */
    public function getSettings()
    {
        return $this->settings;
    }
    /**
     * Set settings value
     * @param \StructType\PvActivitySettingsData $settings
     * @return \StructType\SubscriptionCreate
     */
    public function setSettings(\StructType\PvActivitySettingsData $settings = null)
    {
        $this->settings = $settings;
        return $this;
    }
    /**
     * Get followUp value
     * @return \StructType\PvActivityFollowUpData|null
     */
    public function getFollowUp()
    {
        return $this->followUp;
    }
    /**
     * Set followUp value
     * @param \StructType\PvActivityFollowUpData $followUp
     * @return \StructType\SubscriptionCreate
     */
    public function setFollowUp(\StructType\PvActivityFollowUpData $followUp = null)
    {
        $this->followUp = $followUp;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\SubscriptionCreate
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SubscriptionCreate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
