<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipSearchByName_V2 StructType
 * @subpackage Structs
 */
class RelationshipSearchByName_V2 extends AbstractStructBase
{
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageNumber;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageSize;
    /**
     * The includeFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeFields;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The nameSearchText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nameSearchText;
    /**
     * Constructor method for RelationshipSearchByName_V2
     * @uses RelationshipSearchByName_V2::setPageNumber()
     * @uses RelationshipSearchByName_V2::setPageSize()
     * @uses RelationshipSearchByName_V2::setIncludeFields()
     * @uses RelationshipSearchByName_V2::setCredentials()
     * @uses RelationshipSearchByName_V2::setNameSearchText()
     * @param int $pageNumber
     * @param int $pageSize
     * @param bool $includeFields
     * @param \StructType\ApiCredentials $credentials
     * @param string $nameSearchText
     */
    public function __construct($pageNumber = null, $pageSize = null, $includeFields = null, \StructType\ApiCredentials $credentials = null, $nameSearchText = null)
    {
        $this
            ->setPageNumber($pageNumber)
            ->setPageSize($pageSize)
            ->setIncludeFields($includeFields)
            ->setCredentials($credentials)
            ->setNameSearchText($nameSearchText);
    }
    /**
     * Get pageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param int $pageNumber
     * @return \StructType\RelationshipSearchByName_V2
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\RelationshipSearchByName_V2
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get includeFields value
     * @return bool
     */
    public function getIncludeFields()
    {
        return $this->includeFields;
    }
    /**
     * Set includeFields value
     * @param bool $includeFields
     * @return \StructType\RelationshipSearchByName_V2
     */
    public function setIncludeFields($includeFields = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFields) && !is_bool($includeFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFields, true), gettype($includeFields)), __LINE__);
        }
        $this->includeFields = $includeFields;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationshipSearchByName_V2
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get nameSearchText value
     * @return string|null
     */
    public function getNameSearchText()
    {
        return $this->nameSearchText;
    }
    /**
     * Set nameSearchText value
     * @param string $nameSearchText
     * @return \StructType\RelationshipSearchByName_V2
     */
    public function setNameSearchText($nameSearchText = null)
    {
        // validation for constraint: string
        if (!is_null($nameSearchText) && !is_string($nameSearchText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameSearchText, true), gettype($nameSearchText)), __LINE__);
        }
        $this->nameSearchText = $nameSearchText;
        return $this;
    }
}
