<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipGetMarksResult StructType
 * @subpackage Structs
 */
class RelationshipGetMarksResult extends PvApiResult
{
    /**
     * The Relationship
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationshipData
     */
    public $Relationship;
    /**
     * The RelationshipMarks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvRelationshipMarkData
     */
    public $RelationshipMarks;
    /**
     * Constructor method for RelationshipGetMarksResult
     * @uses RelationshipGetMarksResult::setRelationship()
     * @uses RelationshipGetMarksResult::setRelationshipMarks()
     * @param \StructType\PvRelationshipData $relationship
     * @param \ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks
     */
    public function __construct(\StructType\PvRelationshipData $relationship = null, \ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks = null)
    {
        $this
            ->setRelationship($relationship)
            ->setRelationshipMarks($relationshipMarks);
    }
    /**
     * Get Relationship value
     * @return \StructType\PvRelationshipData|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * Set Relationship value
     * @param \StructType\PvRelationshipData $relationship
     * @return \StructType\RelationshipGetMarksResult
     */
    public function setRelationship(\StructType\PvRelationshipData $relationship = null)
    {
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Get RelationshipMarks value
     * @return \ArrayType\ArrayOfPvRelationshipMarkData|null
     */
    public function getRelationshipMarks()
    {
        return $this->RelationshipMarks;
    }
    /**
     * Set RelationshipMarks value
     * @param \ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks
     * @return \StructType\RelationshipGetMarksResult
     */
    public function setRelationshipMarks(\ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks = null)
    {
        $this->RelationshipMarks = $relationshipMarks;
        return $this;
    }
}
