<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipFieldGetLabels StructType
 * @subpackage Structs
 */
class RelationshipFieldGetLabels extends AbstractStructBase
{
    /**
     * The relationshipId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationshipId;
    /**
     * The fieldId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $fieldId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationshipFieldGetLabels
     * @uses RelationshipFieldGetLabels::setRelationshipId()
     * @uses RelationshipFieldGetLabels::setFieldId()
     * @uses RelationshipFieldGetLabels::setCredentials()
     * @param string $relationshipId
     * @param string $fieldId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($relationshipId = null, $fieldId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setRelationshipId($relationshipId)
            ->setFieldId($fieldId)
            ->setCredentials($credentials);
    }
    /**
     * Get relationshipId value
     * @return string
     */
    public function getRelationshipId()
    {
        return $this->relationshipId;
    }
    /**
     * Set relationshipId value
     * @param string $relationshipId
     * @return \StructType\RelationshipFieldGetLabels
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        $this->relationshipId = $relationshipId;
        return $this;
    }
    /**
     * Get fieldId value
     * @return string
     */
    public function getFieldId()
    {
        return $this->fieldId;
    }
    /**
     * Set fieldId value
     * @param string $fieldId
     * @return \StructType\RelationshipFieldGetLabels
     */
    public function setFieldId($fieldId = null)
    {
        // validation for constraint: string
        if (!is_null($fieldId) && !is_string($fieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldId, true), gettype($fieldId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($fieldId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $fieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($fieldId, true)), __LINE__);
        }
        $this->fieldId = $fieldId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationshipFieldGetLabels
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
