<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipCreate StructType
 * @subpackage Structs
 */
class RelationshipCreate extends AbstractStructBase
{
    /**
     * The parentRelationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $parentRelationId;
    /**
     * The childRelationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $childRelationId;
    /**
     * The relationshipEntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationshipEntityTypeId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The relationshipFieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $relationshipFieldValues;
    /**
     * Constructor method for RelationshipCreate
     * @uses RelationshipCreate::setParentRelationId()
     * @uses RelationshipCreate::setChildRelationId()
     * @uses RelationshipCreate::setRelationshipEntityTypeId()
     * @uses RelationshipCreate::setCredentials()
     * @uses RelationshipCreate::setRelationshipFieldValues()
     * @param string $parentRelationId
     * @param string $childRelationId
     * @param string $relationshipEntityTypeId
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues
     */
    public function __construct($parentRelationId = null, $childRelationId = null, $relationshipEntityTypeId = null, \StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues = null)
    {
        $this
            ->setParentRelationId($parentRelationId)
            ->setChildRelationId($childRelationId)
            ->setRelationshipEntityTypeId($relationshipEntityTypeId)
            ->setCredentials($credentials)
            ->setRelationshipFieldValues($relationshipFieldValues);
    }
    /**
     * Get parentRelationId value
     * @return string
     */
    public function getParentRelationId()
    {
        return $this->parentRelationId;
    }
    /**
     * Set parentRelationId value
     * @param string $parentRelationId
     * @return \StructType\RelationshipCreate
     */
    public function setParentRelationId($parentRelationId = null)
    {
        // validation for constraint: string
        if (!is_null($parentRelationId) && !is_string($parentRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRelationId, true), gettype($parentRelationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($parentRelationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $parentRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($parentRelationId, true)), __LINE__);
        }
        $this->parentRelationId = $parentRelationId;
        return $this;
    }
    /**
     * Get childRelationId value
     * @return string
     */
    public function getChildRelationId()
    {
        return $this->childRelationId;
    }
    /**
     * Set childRelationId value
     * @param string $childRelationId
     * @return \StructType\RelationshipCreate
     */
    public function setChildRelationId($childRelationId = null)
    {
        // validation for constraint: string
        if (!is_null($childRelationId) && !is_string($childRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childRelationId, true), gettype($childRelationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($childRelationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $childRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($childRelationId, true)), __LINE__);
        }
        $this->childRelationId = $childRelationId;
        return $this;
    }
    /**
     * Get relationshipEntityTypeId value
     * @return string
     */
    public function getRelationshipEntityTypeId()
    {
        return $this->relationshipEntityTypeId;
    }
    /**
     * Set relationshipEntityTypeId value
     * @param string $relationshipEntityTypeId
     * @return \StructType\RelationshipCreate
     */
    public function setRelationshipEntityTypeId($relationshipEntityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipEntityTypeId) && !is_string($relationshipEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipEntityTypeId, true), gettype($relationshipEntityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipEntityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipEntityTypeId, true)), __LINE__);
        }
        $this->relationshipEntityTypeId = $relationshipEntityTypeId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationshipCreate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get relationshipFieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getRelationshipFieldValues()
    {
        return $this->relationshipFieldValues;
    }
    /**
     * Set relationshipFieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues
     * @return \StructType\RelationshipCreate
     */
    public function setRelationshipFieldValues(\ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues = null)
    {
        $this->relationshipFieldValues = $relationshipFieldValues;
        return $this;
    }
}
