<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipAddMarkV2 StructType
 * @subpackage Structs
 */
class RelationshipAddMarkV2 extends AbstractStructBase
{
    /**
     * The relationshipId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationshipId;
    /**
     * The markId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $markId;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $date;
    /**
     * The updateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $updateDate;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationshipAddMarkV2
     * @uses RelationshipAddMarkV2::setRelationshipId()
     * @uses RelationshipAddMarkV2::setMarkId()
     * @uses RelationshipAddMarkV2::setDate()
     * @uses RelationshipAddMarkV2::setUpdateDate()
     * @uses RelationshipAddMarkV2::setCredentials()
     * @param string $relationshipId
     * @param string $markId
     * @param string $date
     * @param bool $updateDate
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($relationshipId = null, $markId = null, $date = null, $updateDate = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setRelationshipId($relationshipId)
            ->setMarkId($markId)
            ->setDate($date)
            ->setUpdateDate($updateDate)
            ->setCredentials($credentials);
    }
    /**
     * Get relationshipId value
     * @return string
     */
    public function getRelationshipId()
    {
        return $this->relationshipId;
    }
    /**
     * Set relationshipId value
     * @param string $relationshipId
     * @return \StructType\RelationshipAddMarkV2
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        $this->relationshipId = $relationshipId;
        return $this;
    }
    /**
     * Get markId value
     * @return string
     */
    public function getMarkId()
    {
        return $this->markId;
    }
    /**
     * Set markId value
     * @param string $markId
     * @return \StructType\RelationshipAddMarkV2
     */
    public function setMarkId($markId = null)
    {
        // validation for constraint: string
        if (!is_null($markId) && !is_string($markId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markId, true), gettype($markId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($markId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $markId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($markId, true)), __LINE__);
        }
        $this->markId = $markId;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\RelationshipAddMarkV2
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get updateDate value
     * @return bool
     */
    public function getUpdateDate()
    {
        return $this->updateDate;
    }
    /**
     * Set updateDate value
     * @param bool $updateDate
     * @return \StructType\RelationshipAddMarkV2
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateDate) && !is_bool($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        $this->updateDate = $updateDate;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationshipAddMarkV2
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
