<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationSearchByFieldResult StructType
 * @subpackage Structs
 */
class RelationSearchByFieldResult extends PvApiResult
{
    /**
     * The Relations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvRelationData
     */
    public $Relations;
    /**
     * The ErrorInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorInformation;
    /**
     * Constructor method for RelationSearchByFieldResult
     * @uses RelationSearchByFieldResult::setRelations()
     * @uses RelationSearchByFieldResult::setErrorInformation()
     * @param \ArrayType\ArrayOfPvRelationData $relations
     * @param string $errorInformation
     */
    public function __construct(\ArrayType\ArrayOfPvRelationData $relations = null, $errorInformation = null)
    {
        $this
            ->setRelations($relations)
            ->setErrorInformation($errorInformation);
    }
    /**
     * Get Relations value
     * @return \ArrayType\ArrayOfPvRelationData|null
     */
    public function getRelations()
    {
        return $this->Relations;
    }
    /**
     * Set Relations value
     * @param \ArrayType\ArrayOfPvRelationData $relations
     * @return \StructType\RelationSearchByFieldResult
     */
    public function setRelations(\ArrayType\ArrayOfPvRelationData $relations = null)
    {
        $this->Relations = $relations;
        return $this;
    }
    /**
     * Get ErrorInformation value
     * @return string|null
     */
    public function getErrorInformation()
    {
        return $this->ErrorInformation;
    }
    /**
     * Set ErrorInformation value
     * @param string $errorInformation
     * @return \StructType\RelationSearchByFieldResult
     */
    public function setErrorInformation($errorInformation = null)
    {
        // validation for constraint: string
        if (!is_null($errorInformation) && !is_string($errorInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorInformation, true), gettype($errorInformation)), __LINE__);
        }
        $this->ErrorInformation = $errorInformation;
        return $this;
    }
}
