<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationGetImageResult StructType
 * @subpackage Structs
 */
class RelationGetImageResult extends PvApiResult
{
    /**
     * The Base64EncodedImage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Base64EncodedImage;
    /**
     * Constructor method for RelationGetImageResult
     * @uses RelationGetImageResult::setBase64EncodedImage()
     * @param string $base64EncodedImage
     */
    public function __construct($base64EncodedImage = null)
    {
        $this
            ->setBase64EncodedImage($base64EncodedImage);
    }
    /**
     * Get Base64EncodedImage value
     * @return string|null
     */
    public function getBase64EncodedImage()
    {
        return $this->Base64EncodedImage;
    }
    /**
     * Set Base64EncodedImage value
     * @param string $base64EncodedImage
     * @return \StructType\RelationGetImageResult
     */
    public function setBase64EncodedImage($base64EncodedImage = null)
    {
        // validation for constraint: string
        if (!is_null($base64EncodedImage) && !is_string($base64EncodedImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64EncodedImage, true), gettype($base64EncodedImage)), __LINE__);
        }
        $this->Base64EncodedImage = $base64EncodedImage;
        return $this;
    }
}
