<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationCreate StructType
 * @subpackage Structs
 */
class RelationCreate extends AbstractStructBase
{
    /**
     * The parentRelationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $parentRelationId;
    /**
     * The relationEntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationEntityTypeId;
    /**
     * The relationshipEntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationshipEntityTypeId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The relationFieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $relationFieldValues;
    /**
     * The relationshipFieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $relationshipFieldValues;
    /**
     * Constructor method for RelationCreate
     * @uses RelationCreate::setParentRelationId()
     * @uses RelationCreate::setRelationEntityTypeId()
     * @uses RelationCreate::setRelationshipEntityTypeId()
     * @uses RelationCreate::setCredentials()
     * @uses RelationCreate::setRelationFieldValues()
     * @uses RelationCreate::setRelationshipFieldValues()
     * @param string $parentRelationId
     * @param string $relationEntityTypeId
     * @param string $relationshipEntityTypeId
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfPvFieldValueData $relationFieldValues
     * @param \ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues
     */
    public function __construct($parentRelationId = null, $relationEntityTypeId = null, $relationshipEntityTypeId = null, \StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfPvFieldValueData $relationFieldValues = null, \ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues = null)
    {
        $this
            ->setParentRelationId($parentRelationId)
            ->setRelationEntityTypeId($relationEntityTypeId)
            ->setRelationshipEntityTypeId($relationshipEntityTypeId)
            ->setCredentials($credentials)
            ->setRelationFieldValues($relationFieldValues)
            ->setRelationshipFieldValues($relationshipFieldValues);
    }
    /**
     * Get parentRelationId value
     * @return string
     */
    public function getParentRelationId()
    {
        return $this->parentRelationId;
    }
    /**
     * Set parentRelationId value
     * @param string $parentRelationId
     * @return \StructType\RelationCreate
     */
    public function setParentRelationId($parentRelationId = null)
    {
        // validation for constraint: string
        if (!is_null($parentRelationId) && !is_string($parentRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRelationId, true), gettype($parentRelationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($parentRelationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $parentRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($parentRelationId, true)), __LINE__);
        }
        $this->parentRelationId = $parentRelationId;
        return $this;
    }
    /**
     * Get relationEntityTypeId value
     * @return string
     */
    public function getRelationEntityTypeId()
    {
        return $this->relationEntityTypeId;
    }
    /**
     * Set relationEntityTypeId value
     * @param string $relationEntityTypeId
     * @return \StructType\RelationCreate
     */
    public function setRelationEntityTypeId($relationEntityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationEntityTypeId) && !is_string($relationEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationEntityTypeId, true), gettype($relationEntityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationEntityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationEntityTypeId, true)), __LINE__);
        }
        $this->relationEntityTypeId = $relationEntityTypeId;
        return $this;
    }
    /**
     * Get relationshipEntityTypeId value
     * @return string
     */
    public function getRelationshipEntityTypeId()
    {
        return $this->relationshipEntityTypeId;
    }
    /**
     * Set relationshipEntityTypeId value
     * @param string $relationshipEntityTypeId
     * @return \StructType\RelationCreate
     */
    public function setRelationshipEntityTypeId($relationshipEntityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipEntityTypeId) && !is_string($relationshipEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipEntityTypeId, true), gettype($relationshipEntityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipEntityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipEntityTypeId, true)), __LINE__);
        }
        $this->relationshipEntityTypeId = $relationshipEntityTypeId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationCreate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get relationFieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getRelationFieldValues()
    {
        return $this->relationFieldValues;
    }
    /**
     * Set relationFieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $relationFieldValues
     * @return \StructType\RelationCreate
     */
    public function setRelationFieldValues(\ArrayType\ArrayOfPvFieldValueData $relationFieldValues = null)
    {
        $this->relationFieldValues = $relationFieldValues;
        return $this;
    }
    /**
     * Get relationshipFieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getRelationshipFieldValues()
    {
        return $this->relationshipFieldValues;
    }
    /**
     * Set relationshipFieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues
     * @return \StructType\RelationCreate
     */
    public function setRelationshipFieldValues(\ArrayType\ArrayOfPvFieldValueData $relationshipFieldValues = null)
    {
        $this->relationshipFieldValues = $relationshipFieldValues;
        return $this;
    }
}
