<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvUserDatabase StructType
 * @subpackage Structs
 */
class PvUserDatabase extends AbstractStructBase
{
    /**
     * The ApiKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ApiKey;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $UserId;
    /**
     * The DatabaseId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $DatabaseId;
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The UserDisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserDisplayName;
    /**
     * The DatabaseName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabaseName;
    /**
     * The RootRelationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RootRelationName;
    /**
     * Constructor method for PvUserDatabase
     * @uses PvUserDatabase::setApiKey()
     * @uses PvUserDatabase::setUserId()
     * @uses PvUserDatabase::setDatabaseId()
     * @uses PvUserDatabase::setAccountName()
     * @uses PvUserDatabase::setUserDisplayName()
     * @uses PvUserDatabase::setDatabaseName()
     * @uses PvUserDatabase::setRootRelationName()
     * @param string $apiKey
     * @param string $userId
     * @param string $databaseId
     * @param string $accountName
     * @param string $userDisplayName
     * @param string $databaseName
     * @param string $rootRelationName
     */
    public function __construct($apiKey = null, $userId = null, $databaseId = null, $accountName = null, $userDisplayName = null, $databaseName = null, $rootRelationName = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setUserId($userId)
            ->setDatabaseId($databaseId)
            ->setAccountName($accountName)
            ->setUserDisplayName($userDisplayName)
            ->setDatabaseName($databaseName)
            ->setRootRelationName($rootRelationName);
    }
    /**
     * Get ApiKey value
     * @return string
     */
    public function getApiKey()
    {
        return $this->ApiKey;
    }
    /**
     * Set ApiKey value
     * @param string $apiKey
     * @return \StructType\PvUserDatabase
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($apiKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($apiKey, true)), __LINE__);
        }
        $this->ApiKey = $apiKey;
        return $this;
    }
    /**
     * Get UserId value
     * @return string
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\PvUserDatabase
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get DatabaseId value
     * @return string
     */
    public function getDatabaseId()
    {
        return $this->DatabaseId;
    }
    /**
     * Set DatabaseId value
     * @param string $databaseId
     * @return \StructType\PvUserDatabase
     */
    public function setDatabaseId($databaseId = null)
    {
        // validation for constraint: string
        if (!is_null($databaseId) && !is_string($databaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseId, true), gettype($databaseId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($databaseId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $databaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($databaseId, true)), __LINE__);
        }
        $this->DatabaseId = $databaseId;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\PvUserDatabase
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get UserDisplayName value
     * @return string|null
     */
    public function getUserDisplayName()
    {
        return $this->UserDisplayName;
    }
    /**
     * Set UserDisplayName value
     * @param string $userDisplayName
     * @return \StructType\PvUserDatabase
     */
    public function setUserDisplayName($userDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($userDisplayName) && !is_string($userDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userDisplayName, true), gettype($userDisplayName)), __LINE__);
        }
        $this->UserDisplayName = $userDisplayName;
        return $this;
    }
    /**
     * Get DatabaseName value
     * @return string|null
     */
    public function getDatabaseName()
    {
        return $this->DatabaseName;
    }
    /**
     * Set DatabaseName value
     * @param string $databaseName
     * @return \StructType\PvUserDatabase
     */
    public function setDatabaseName($databaseName = null)
    {
        // validation for constraint: string
        if (!is_null($databaseName) && !is_string($databaseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseName, true), gettype($databaseName)), __LINE__);
        }
        $this->DatabaseName = $databaseName;
        return $this;
    }
    /**
     * Get RootRelationName value
     * @return string|null
     */
    public function getRootRelationName()
    {
        return $this->RootRelationName;
    }
    /**
     * Set RootRelationName value
     * @param string $rootRelationName
     * @return \StructType\PvUserDatabase
     */
    public function setRootRelationName($rootRelationName = null)
    {
        // validation for constraint: string
        if (!is_null($rootRelationName) && !is_string($rootRelationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rootRelationName, true), gettype($rootRelationName)), __LINE__);
        }
        $this->RootRelationName = $rootRelationName;
        return $this;
    }
}
