<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvRelationshipMarkData StructType
 * @subpackage Structs
 */
class PvRelationshipMarkData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $RelationshipId;
    /**
     * The MarkId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MarkId;
    /**
     * The PreferredAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PreferredAddress;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The RelationshipDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelationshipDescription;
    /**
     * Constructor method for PvRelationshipMarkData
     * @uses PvRelationshipMarkData::setId()
     * @uses PvRelationshipMarkData::setRelationshipId()
     * @uses PvRelationshipMarkData::setMarkId()
     * @uses PvRelationshipMarkData::setPreferredAddress()
     * @uses PvRelationshipMarkData::setDate()
     * @uses PvRelationshipMarkData::setRelationshipDescription()
     * @param string $id
     * @param string $relationshipId
     * @param string $markId
     * @param string $preferredAddress
     * @param string $date
     * @param string $relationshipDescription
     */
    public function __construct($id = null, $relationshipId = null, $markId = null, $preferredAddress = null, $date = null, $relationshipDescription = null)
    {
        $this
            ->setId($id)
            ->setRelationshipId($relationshipId)
            ->setMarkId($markId)
            ->setPreferredAddress($preferredAddress)
            ->setDate($date)
            ->setRelationshipDescription($relationshipDescription);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvRelationshipMarkData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RelationshipId value
     * @return string
     */
    public function getRelationshipId()
    {
        return $this->RelationshipId;
    }
    /**
     * Set RelationshipId value
     * @param string $relationshipId
     * @return \StructType\PvRelationshipMarkData
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        $this->RelationshipId = $relationshipId;
        return $this;
    }
    /**
     * Get MarkId value
     * @return string
     */
    public function getMarkId()
    {
        return $this->MarkId;
    }
    /**
     * Set MarkId value
     * @param string $markId
     * @return \StructType\PvRelationshipMarkData
     */
    public function setMarkId($markId = null)
    {
        // validation for constraint: string
        if (!is_null($markId) && !is_string($markId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markId, true), gettype($markId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($markId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $markId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($markId, true)), __LINE__);
        }
        $this->MarkId = $markId;
        return $this;
    }
    /**
     * Get PreferredAddress value
     * @return string
     */
    public function getPreferredAddress()
    {
        return $this->PreferredAddress;
    }
    /**
     * Set PreferredAddress value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferredAddress
     * @return \StructType\PvRelationshipMarkData
     */
    public function setPreferredAddress($preferredAddress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($preferredAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AddressType', is_array($preferredAddress) ? implode(', ', $preferredAddress) : var_export($preferredAddress, true), implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->PreferredAddress = $preferredAddress;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\PvRelationshipMarkData
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get RelationshipDescription value
     * @return string|null
     */
    public function getRelationshipDescription()
    {
        return $this->RelationshipDescription;
    }
    /**
     * Set RelationshipDescription value
     * @param string $relationshipDescription
     * @return \StructType\PvRelationshipMarkData
     */
    public function setRelationshipDescription($relationshipDescription = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipDescription) && !is_string($relationshipDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipDescription, true), gettype($relationshipDescription)), __LINE__);
        }
        $this->RelationshipDescription = $relationshipDescription;
        return $this;
    }
}
