<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvRelationshipData StructType
 * @subpackage Structs
 */
class PvRelationshipData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The EntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityTypeId;
    /**
     * The ParentRelationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ParentRelationId;
    /**
     * The ChildRelationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ChildRelationId;
    /**
     * The IsContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsContact;
    /**
     * The IsEmployee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEmployee;
    /**
     * The IsOrganisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOrganisation;
    /**
     * The PreferredAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PreferredAddress;
    /**
     * The AddresStyle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AddresStyle;
    /**
     * The TittleId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $TittleId;
    /**
     * The AccountManagerId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $AccountManagerId;
    /**
     * The IsInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInactive;
    /**
     * The OptOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OptOut;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DisplayCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayCity;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The SortingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortingName;
    /**
     * The Addressing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Addressing;
    /**
     * The Openening
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Openening;
    /**
     * The AddressingVariant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressingVariant;
    /**
     * The OpeneningVariant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpeneningVariant;
    /**
     * The AuditData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvAuditData
     */
    public $AuditData;
    /**
     * The FieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvFieldValuesData
     */
    public $FieldValues;
    /**
     * Constructor method for PvRelationshipData
     * @uses PvRelationshipData::setId()
     * @uses PvRelationshipData::setEntityTypeId()
     * @uses PvRelationshipData::setParentRelationId()
     * @uses PvRelationshipData::setChildRelationId()
     * @uses PvRelationshipData::setIsContact()
     * @uses PvRelationshipData::setIsEmployee()
     * @uses PvRelationshipData::setIsOrganisation()
     * @uses PvRelationshipData::setPreferredAddress()
     * @uses PvRelationshipData::setAddresStyle()
     * @uses PvRelationshipData::setTittleId()
     * @uses PvRelationshipData::setAccountManagerId()
     * @uses PvRelationshipData::setIsInactive()
     * @uses PvRelationshipData::setOptOut()
     * @uses PvRelationshipData::setDescription()
     * @uses PvRelationshipData::setDisplayCity()
     * @uses PvRelationshipData::setDisplayName()
     * @uses PvRelationshipData::setSortingName()
     * @uses PvRelationshipData::setAddressing()
     * @uses PvRelationshipData::setOpenening()
     * @uses PvRelationshipData::setAddressingVariant()
     * @uses PvRelationshipData::setOpeneningVariant()
     * @uses PvRelationshipData::setAuditData()
     * @uses PvRelationshipData::setFieldValues()
     * @param string $id
     * @param string $entityTypeId
     * @param string $parentRelationId
     * @param string $childRelationId
     * @param bool $isContact
     * @param bool $isEmployee
     * @param bool $isOrganisation
     * @param string $preferredAddress
     * @param string $addresStyle
     * @param string $tittleId
     * @param string $accountManagerId
     * @param bool $isInactive
     * @param bool $optOut
     * @param string $description
     * @param string $displayCity
     * @param string $displayName
     * @param string $sortingName
     * @param string $addressing
     * @param string $openening
     * @param string $addressingVariant
     * @param string $openeningVariant
     * @param \StructType\PvAuditData $auditData
     * @param \StructType\PvFieldValuesData $fieldValues
     */
    public function __construct($id = null, $entityTypeId = null, $parentRelationId = null, $childRelationId = null, $isContact = null, $isEmployee = null, $isOrganisation = null, $preferredAddress = null, $addresStyle = null, $tittleId = null, $accountManagerId = null, $isInactive = null, $optOut = null, $description = null, $displayCity = null, $displayName = null, $sortingName = null, $addressing = null, $openening = null, $addressingVariant = null, $openeningVariant = null, \StructType\PvAuditData $auditData = null, \StructType\PvFieldValuesData $fieldValues = null)
    {
        $this
            ->setId($id)
            ->setEntityTypeId($entityTypeId)
            ->setParentRelationId($parentRelationId)
            ->setChildRelationId($childRelationId)
            ->setIsContact($isContact)
            ->setIsEmployee($isEmployee)
            ->setIsOrganisation($isOrganisation)
            ->setPreferredAddress($preferredAddress)
            ->setAddresStyle($addresStyle)
            ->setTittleId($tittleId)
            ->setAccountManagerId($accountManagerId)
            ->setIsInactive($isInactive)
            ->setOptOut($optOut)
            ->setDescription($description)
            ->setDisplayCity($displayCity)
            ->setDisplayName($displayName)
            ->setSortingName($sortingName)
            ->setAddressing($addressing)
            ->setOpenening($openening)
            ->setAddressingVariant($addressingVariant)
            ->setOpeneningVariant($openeningVariant)
            ->setAuditData($auditData)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvRelationshipData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get EntityTypeId value
     * @return string
     */
    public function getEntityTypeId()
    {
        return $this->EntityTypeId;
    }
    /**
     * Set EntityTypeId value
     * @param string $entityTypeId
     * @return \StructType\PvRelationshipData
     */
    public function setEntityTypeId($entityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeId) && !is_string($entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeId, true), gettype($entityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityTypeId, true)), __LINE__);
        }
        $this->EntityTypeId = $entityTypeId;
        return $this;
    }
    /**
     * Get ParentRelationId value
     * @return string
     */
    public function getParentRelationId()
    {
        return $this->ParentRelationId;
    }
    /**
     * Set ParentRelationId value
     * @param string $parentRelationId
     * @return \StructType\PvRelationshipData
     */
    public function setParentRelationId($parentRelationId = null)
    {
        // validation for constraint: string
        if (!is_null($parentRelationId) && !is_string($parentRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRelationId, true), gettype($parentRelationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($parentRelationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $parentRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($parentRelationId, true)), __LINE__);
        }
        $this->ParentRelationId = $parentRelationId;
        return $this;
    }
    /**
     * Get ChildRelationId value
     * @return string
     */
    public function getChildRelationId()
    {
        return $this->ChildRelationId;
    }
    /**
     * Set ChildRelationId value
     * @param string $childRelationId
     * @return \StructType\PvRelationshipData
     */
    public function setChildRelationId($childRelationId = null)
    {
        // validation for constraint: string
        if (!is_null($childRelationId) && !is_string($childRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childRelationId, true), gettype($childRelationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($childRelationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $childRelationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($childRelationId, true)), __LINE__);
        }
        $this->ChildRelationId = $childRelationId;
        return $this;
    }
    /**
     * Get IsContact value
     * @return bool
     */
    public function getIsContact()
    {
        return $this->IsContact;
    }
    /**
     * Set IsContact value
     * @param bool $isContact
     * @return \StructType\PvRelationshipData
     */
    public function setIsContact($isContact = null)
    {
        // validation for constraint: boolean
        if (!is_null($isContact) && !is_bool($isContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isContact, true), gettype($isContact)), __LINE__);
        }
        $this->IsContact = $isContact;
        return $this;
    }
    /**
     * Get IsEmployee value
     * @return bool
     */
    public function getIsEmployee()
    {
        return $this->IsEmployee;
    }
    /**
     * Set IsEmployee value
     * @param bool $isEmployee
     * @return \StructType\PvRelationshipData
     */
    public function setIsEmployee($isEmployee = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEmployee) && !is_bool($isEmployee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEmployee, true), gettype($isEmployee)), __LINE__);
        }
        $this->IsEmployee = $isEmployee;
        return $this;
    }
    /**
     * Get IsOrganisation value
     * @return bool
     */
    public function getIsOrganisation()
    {
        return $this->IsOrganisation;
    }
    /**
     * Set IsOrganisation value
     * @param bool $isOrganisation
     * @return \StructType\PvRelationshipData
     */
    public function setIsOrganisation($isOrganisation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOrganisation) && !is_bool($isOrganisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOrganisation, true), gettype($isOrganisation)), __LINE__);
        }
        $this->IsOrganisation = $isOrganisation;
        return $this;
    }
    /**
     * Get PreferredAddress value
     * @return string
     */
    public function getPreferredAddress()
    {
        return $this->PreferredAddress;
    }
    /**
     * Set PreferredAddress value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferredAddress
     * @return \StructType\PvRelationshipData
     */
    public function setPreferredAddress($preferredAddress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($preferredAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AddressType', is_array($preferredAddress) ? implode(', ', $preferredAddress) : var_export($preferredAddress, true), implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->PreferredAddress = $preferredAddress;
        return $this;
    }
    /**
     * Get AddresStyle value
     * @return string
     */
    public function getAddresStyle()
    {
        return $this->AddresStyle;
    }
    /**
     * Set AddresStyle value
     * @uses \EnumType\AddressStyle::valueIsValid()
     * @uses \EnumType\AddressStyle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addresStyle
     * @return \StructType\PvRelationshipData
     */
    public function setAddresStyle($addresStyle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressStyle::valueIsValid($addresStyle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AddressStyle', is_array($addresStyle) ? implode(', ', $addresStyle) : var_export($addresStyle, true), implode(', ', \EnumType\AddressStyle::getValidValues())), __LINE__);
        }
        $this->AddresStyle = $addresStyle;
        return $this;
    }
    /**
     * Get TittleId value
     * @return string
     */
    public function getTittleId()
    {
        return $this->TittleId;
    }
    /**
     * Set TittleId value
     * @param string $tittleId
     * @return \StructType\PvRelationshipData
     */
    public function setTittleId($tittleId = null)
    {
        // validation for constraint: string
        if (!is_null($tittleId) && !is_string($tittleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tittleId, true), gettype($tittleId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($tittleId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $tittleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($tittleId, true)), __LINE__);
        }
        $this->TittleId = $tittleId;
        return $this;
    }
    /**
     * Get AccountManagerId value
     * @return string
     */
    public function getAccountManagerId()
    {
        return $this->AccountManagerId;
    }
    /**
     * Set AccountManagerId value
     * @param string $accountManagerId
     * @return \StructType\PvRelationshipData
     */
    public function setAccountManagerId($accountManagerId = null)
    {
        // validation for constraint: string
        if (!is_null($accountManagerId) && !is_string($accountManagerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountManagerId, true), gettype($accountManagerId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($accountManagerId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $accountManagerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($accountManagerId, true)), __LINE__);
        }
        $this->AccountManagerId = $accountManagerId;
        return $this;
    }
    /**
     * Get IsInactive value
     * @return bool
     */
    public function getIsInactive()
    {
        return $this->IsInactive;
    }
    /**
     * Set IsInactive value
     * @param bool $isInactive
     * @return \StructType\PvRelationshipData
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->IsInactive = $isInactive;
        return $this;
    }
    /**
     * Get OptOut value
     * @return bool
     */
    public function getOptOut()
    {
        return $this->OptOut;
    }
    /**
     * Set OptOut value
     * @param bool $optOut
     * @return \StructType\PvRelationshipData
     */
    public function setOptOut($optOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($optOut) && !is_bool($optOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optOut, true), gettype($optOut)), __LINE__);
        }
        $this->OptOut = $optOut;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PvRelationshipData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DisplayCity value
     * @return string|null
     */
    public function getDisplayCity()
    {
        return $this->DisplayCity;
    }
    /**
     * Set DisplayCity value
     * @param string $displayCity
     * @return \StructType\PvRelationshipData
     */
    public function setDisplayCity($displayCity = null)
    {
        // validation for constraint: string
        if (!is_null($displayCity) && !is_string($displayCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayCity, true), gettype($displayCity)), __LINE__);
        }
        $this->DisplayCity = $displayCity;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PvRelationshipData
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get SortingName value
     * @return string|null
     */
    public function getSortingName()
    {
        return $this->SortingName;
    }
    /**
     * Set SortingName value
     * @param string $sortingName
     * @return \StructType\PvRelationshipData
     */
    public function setSortingName($sortingName = null)
    {
        // validation for constraint: string
        if (!is_null($sortingName) && !is_string($sortingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortingName, true), gettype($sortingName)), __LINE__);
        }
        $this->SortingName = $sortingName;
        return $this;
    }
    /**
     * Get Addressing value
     * @return string|null
     */
    public function getAddressing()
    {
        return $this->Addressing;
    }
    /**
     * Set Addressing value
     * @param string $addressing
     * @return \StructType\PvRelationshipData
     */
    public function setAddressing($addressing = null)
    {
        // validation for constraint: string
        if (!is_null($addressing) && !is_string($addressing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressing, true), gettype($addressing)), __LINE__);
        }
        $this->Addressing = $addressing;
        return $this;
    }
    /**
     * Get Openening value
     * @return string|null
     */
    public function getOpenening()
    {
        return $this->Openening;
    }
    /**
     * Set Openening value
     * @param string $openening
     * @return \StructType\PvRelationshipData
     */
    public function setOpenening($openening = null)
    {
        // validation for constraint: string
        if (!is_null($openening) && !is_string($openening)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openening, true), gettype($openening)), __LINE__);
        }
        $this->Openening = $openening;
        return $this;
    }
    /**
     * Get AddressingVariant value
     * @return string|null
     */
    public function getAddressingVariant()
    {
        return $this->AddressingVariant;
    }
    /**
     * Set AddressingVariant value
     * @param string $addressingVariant
     * @return \StructType\PvRelationshipData
     */
    public function setAddressingVariant($addressingVariant = null)
    {
        // validation for constraint: string
        if (!is_null($addressingVariant) && !is_string($addressingVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressingVariant, true), gettype($addressingVariant)), __LINE__);
        }
        $this->AddressingVariant = $addressingVariant;
        return $this;
    }
    /**
     * Get OpeneningVariant value
     * @return string|null
     */
    public function getOpeneningVariant()
    {
        return $this->OpeneningVariant;
    }
    /**
     * Set OpeneningVariant value
     * @param string $openeningVariant
     * @return \StructType\PvRelationshipData
     */
    public function setOpeneningVariant($openeningVariant = null)
    {
        // validation for constraint: string
        if (!is_null($openeningVariant) && !is_string($openeningVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openeningVariant, true), gettype($openeningVariant)), __LINE__);
        }
        $this->OpeneningVariant = $openeningVariant;
        return $this;
    }
    /**
     * Get AuditData value
     * @return \StructType\PvAuditData|null
     */
    public function getAuditData()
    {
        return $this->AuditData;
    }
    /**
     * Set AuditData value
     * @param \StructType\PvAuditData $auditData
     * @return \StructType\PvRelationshipData
     */
    public function setAuditData(\StructType\PvAuditData $auditData = null)
    {
        $this->AuditData = $auditData;
        return $this;
    }
    /**
     * Get FieldValues value
     * @return \StructType\PvFieldValuesData|null
     */
    public function getFieldValues()
    {
        return $this->FieldValues;
    }
    /**
     * Set FieldValues value
     * @param \StructType\PvFieldValuesData $fieldValues
     * @return \StructType\PvRelationshipData
     */
    public function setFieldValues(\StructType\PvFieldValuesData $fieldValues = null)
    {
        $this->FieldValues = $fieldValues;
        return $this;
    }
}
