<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvRelationData StructType
 * @subpackage Structs
 */
class PvRelationData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The EntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityTypeId;
    /**
     * The IsRoot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRoot;
    /**
     * The IsDummy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDummy;
    /**
     * The IsInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInactive;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The SortingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortingName;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ImportKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImportKey;
    /**
     * The FieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvFieldValuesData
     */
    public $FieldValues;
    /**
     * The CounterValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvCounterData
     */
    public $CounterValues;
    /**
     * Constructor method for PvRelationData
     * @uses PvRelationData::setId()
     * @uses PvRelationData::setEntityTypeId()
     * @uses PvRelationData::setIsRoot()
     * @uses PvRelationData::setIsDummy()
     * @uses PvRelationData::setIsInactive()
     * @uses PvRelationData::setInfo()
     * @uses PvRelationData::setSortingName()
     * @uses PvRelationData::setDisplayName()
     * @uses PvRelationData::setImportKey()
     * @uses PvRelationData::setFieldValues()
     * @uses PvRelationData::setCounterValues()
     * @param string $id
     * @param string $entityTypeId
     * @param bool $isRoot
     * @param bool $isDummy
     * @param bool $isInactive
     * @param string $info
     * @param string $sortingName
     * @param string $displayName
     * @param string $importKey
     * @param \StructType\PvFieldValuesData $fieldValues
     * @param \ArrayType\ArrayOfPvCounterData $counterValues
     */
    public function __construct($id = null, $entityTypeId = null, $isRoot = null, $isDummy = null, $isInactive = null, $info = null, $sortingName = null, $displayName = null, $importKey = null, \StructType\PvFieldValuesData $fieldValues = null, \ArrayType\ArrayOfPvCounterData $counterValues = null)
    {
        $this
            ->setId($id)
            ->setEntityTypeId($entityTypeId)
            ->setIsRoot($isRoot)
            ->setIsDummy($isDummy)
            ->setIsInactive($isInactive)
            ->setInfo($info)
            ->setSortingName($sortingName)
            ->setDisplayName($displayName)
            ->setImportKey($importKey)
            ->setFieldValues($fieldValues)
            ->setCounterValues($counterValues);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvRelationData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get EntityTypeId value
     * @return string
     */
    public function getEntityTypeId()
    {
        return $this->EntityTypeId;
    }
    /**
     * Set EntityTypeId value
     * @param string $entityTypeId
     * @return \StructType\PvRelationData
     */
    public function setEntityTypeId($entityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeId) && !is_string($entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeId, true), gettype($entityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityTypeId, true)), __LINE__);
        }
        $this->EntityTypeId = $entityTypeId;
        return $this;
    }
    /**
     * Get IsRoot value
     * @return bool
     */
    public function getIsRoot()
    {
        return $this->IsRoot;
    }
    /**
     * Set IsRoot value
     * @param bool $isRoot
     * @return \StructType\PvRelationData
     */
    public function setIsRoot($isRoot = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoot) && !is_bool($isRoot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoot, true), gettype($isRoot)), __LINE__);
        }
        $this->IsRoot = $isRoot;
        return $this;
    }
    /**
     * Get IsDummy value
     * @return bool
     */
    public function getIsDummy()
    {
        return $this->IsDummy;
    }
    /**
     * Set IsDummy value
     * @param bool $isDummy
     * @return \StructType\PvRelationData
     */
    public function setIsDummy($isDummy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDummy) && !is_bool($isDummy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDummy, true), gettype($isDummy)), __LINE__);
        }
        $this->IsDummy = $isDummy;
        return $this;
    }
    /**
     * Get IsInactive value
     * @return bool
     */
    public function getIsInactive()
    {
        return $this->IsInactive;
    }
    /**
     * Set IsInactive value
     * @param bool $isInactive
     * @return \StructType\PvRelationData
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->IsInactive = $isInactive;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\PvRelationData
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get SortingName value
     * @return string|null
     */
    public function getSortingName()
    {
        return $this->SortingName;
    }
    /**
     * Set SortingName value
     * @param string $sortingName
     * @return \StructType\PvRelationData
     */
    public function setSortingName($sortingName = null)
    {
        // validation for constraint: string
        if (!is_null($sortingName) && !is_string($sortingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortingName, true), gettype($sortingName)), __LINE__);
        }
        $this->SortingName = $sortingName;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PvRelationData
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ImportKey value
     * @return string|null
     */
    public function getImportKey()
    {
        return $this->ImportKey;
    }
    /**
     * Set ImportKey value
     * @param string $importKey
     * @return \StructType\PvRelationData
     */
    public function setImportKey($importKey = null)
    {
        // validation for constraint: string
        if (!is_null($importKey) && !is_string($importKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importKey, true), gettype($importKey)), __LINE__);
        }
        $this->ImportKey = $importKey;
        return $this;
    }
    /**
     * Get FieldValues value
     * @return \StructType\PvFieldValuesData|null
     */
    public function getFieldValues()
    {
        return $this->FieldValues;
    }
    /**
     * Set FieldValues value
     * @param \StructType\PvFieldValuesData $fieldValues
     * @return \StructType\PvRelationData
     */
    public function setFieldValues(\StructType\PvFieldValuesData $fieldValues = null)
    {
        $this->FieldValues = $fieldValues;
        return $this;
    }
    /**
     * Get CounterValues value
     * @return \ArrayType\ArrayOfPvCounterData|null
     */
    public function getCounterValues()
    {
        return $this->CounterValues;
    }
    /**
     * Set CounterValues value
     * @param \ArrayType\ArrayOfPvCounterData $counterValues
     * @return \StructType\PvRelationData
     */
    public function setCounterValues(\ArrayType\ArrayOfPvCounterData $counterValues = null)
    {
        $this->CounterValues = $counterValues;
        return $this;
    }
}
