<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvProductData_V2 StructType
 * @subpackage Structs
 */
class PvProductData_V2 extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The ProductGroupId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ProductGroupId;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductType;
    /**
     * The Unit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Unit;
    /**
     * The IsDivisible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDivisible;
    /**
     * The SalesPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SalesPrice;
    /**
     * The IsSalesPriceInclusiveVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSalesPriceInclusiveVat;
    /**
     * The SalesVatId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $SalesVatId;
    /**
     * The PurchasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PurchasePrice;
    /**
     * The IsInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInactive;
    /**
     * The AllowChangePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowChangePrice;
    /**
     * The AllowChangeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowChangeDescription;
    /**
     * The AllowChangeVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowChangeVat;
    /**
     * The AutoEnableEdit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AutoEnableEdit;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PvProductData_V2
     * @uses PvProductData_V2::setId()
     * @uses PvProductData_V2::setProductGroupId()
     * @uses PvProductData_V2::setProductType()
     * @uses PvProductData_V2::setUnit()
     * @uses PvProductData_V2::setIsDivisible()
     * @uses PvProductData_V2::setSalesPrice()
     * @uses PvProductData_V2::setIsSalesPriceInclusiveVat()
     * @uses PvProductData_V2::setSalesVatId()
     * @uses PvProductData_V2::setPurchasePrice()
     * @uses PvProductData_V2::setIsInactive()
     * @uses PvProductData_V2::setAllowChangePrice()
     * @uses PvProductData_V2::setAllowChangeDescription()
     * @uses PvProductData_V2::setAllowChangeVat()
     * @uses PvProductData_V2::setAutoEnableEdit()
     * @uses PvProductData_V2::setCode()
     * @uses PvProductData_V2::setName()
     * @uses PvProductData_V2::setDescription()
     * @param string $id
     * @param string $productGroupId
     * @param string $productType
     * @param int $unit
     * @param bool $isDivisible
     * @param float $salesPrice
     * @param bool $isSalesPriceInclusiveVat
     * @param string $salesVatId
     * @param float $purchasePrice
     * @param bool $isInactive
     * @param bool $allowChangePrice
     * @param bool $allowChangeDescription
     * @param bool $allowChangeVat
     * @param bool $autoEnableEdit
     * @param string $code
     * @param string $name
     * @param string $description
     */
    public function __construct($id = null, $productGroupId = null, $productType = null, $unit = null, $isDivisible = null, $salesPrice = null, $isSalesPriceInclusiveVat = null, $salesVatId = null, $purchasePrice = null, $isInactive = null, $allowChangePrice = null, $allowChangeDescription = null, $allowChangeVat = null, $autoEnableEdit = null, $code = null, $name = null, $description = null)
    {
        $this
            ->setId($id)
            ->setProductGroupId($productGroupId)
            ->setProductType($productType)
            ->setUnit($unit)
            ->setIsDivisible($isDivisible)
            ->setSalesPrice($salesPrice)
            ->setIsSalesPriceInclusiveVat($isSalesPriceInclusiveVat)
            ->setSalesVatId($salesVatId)
            ->setPurchasePrice($purchasePrice)
            ->setIsInactive($isInactive)
            ->setAllowChangePrice($allowChangePrice)
            ->setAllowChangeDescription($allowChangeDescription)
            ->setAllowChangeVat($allowChangeVat)
            ->setAutoEnableEdit($autoEnableEdit)
            ->setCode($code)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvProductData_V2
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ProductGroupId value
     * @return string
     */
    public function getProductGroupId()
    {
        return $this->ProductGroupId;
    }
    /**
     * Set ProductGroupId value
     * @param string $productGroupId
     * @return \StructType\PvProductData_V2
     */
    public function setProductGroupId($productGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupId) && !is_string($productGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroupId, true), gettype($productGroupId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($productGroupId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $productGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($productGroupId, true)), __LINE__);
        }
        $this->ProductGroupId = $productGroupId;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\PvProductData_V2
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get Unit value
     * @return int
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param int $unit
     * @return \StructType\PvProductData_V2
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: int
        if (!is_null($unit) && !(is_int($unit) || ctype_digit($unit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get IsDivisible value
     * @return bool
     */
    public function getIsDivisible()
    {
        return $this->IsDivisible;
    }
    /**
     * Set IsDivisible value
     * @param bool $isDivisible
     * @return \StructType\PvProductData_V2
     */
    public function setIsDivisible($isDivisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDivisible) && !is_bool($isDivisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDivisible, true), gettype($isDivisible)), __LINE__);
        }
        $this->IsDivisible = $isDivisible;
        return $this;
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\PvProductData_V2
     */
    public function setSalesPrice($salesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($salesPrice) && !(is_float($salesPrice) || is_numeric($salesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesPrice, true), gettype($salesPrice)), __LINE__);
        }
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get IsSalesPriceInclusiveVat value
     * @return bool
     */
    public function getIsSalesPriceInclusiveVat()
    {
        return $this->IsSalesPriceInclusiveVat;
    }
    /**
     * Set IsSalesPriceInclusiveVat value
     * @param bool $isSalesPriceInclusiveVat
     * @return \StructType\PvProductData_V2
     */
    public function setIsSalesPriceInclusiveVat($isSalesPriceInclusiveVat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesPriceInclusiveVat) && !is_bool($isSalesPriceInclusiveVat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesPriceInclusiveVat, true), gettype($isSalesPriceInclusiveVat)), __LINE__);
        }
        $this->IsSalesPriceInclusiveVat = $isSalesPriceInclusiveVat;
        return $this;
    }
    /**
     * Get SalesVatId value
     * @return string
     */
    public function getSalesVatId()
    {
        return $this->SalesVatId;
    }
    /**
     * Set SalesVatId value
     * @param string $salesVatId
     * @return \StructType\PvProductData_V2
     */
    public function setSalesVatId($salesVatId = null)
    {
        // validation for constraint: string
        if (!is_null($salesVatId) && !is_string($salesVatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesVatId, true), gettype($salesVatId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($salesVatId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $salesVatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($salesVatId, true)), __LINE__);
        }
        $this->SalesVatId = $salesVatId;
        return $this;
    }
    /**
     * Get PurchasePrice value
     * @return float
     */
    public function getPurchasePrice()
    {
        return $this->PurchasePrice;
    }
    /**
     * Set PurchasePrice value
     * @param float $purchasePrice
     * @return \StructType\PvProductData_V2
     */
    public function setPurchasePrice($purchasePrice = null)
    {
        // validation for constraint: float
        if (!is_null($purchasePrice) && !(is_float($purchasePrice) || is_numeric($purchasePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchasePrice, true), gettype($purchasePrice)), __LINE__);
        }
        $this->PurchasePrice = $purchasePrice;
        return $this;
    }
    /**
     * Get IsInactive value
     * @return bool
     */
    public function getIsInactive()
    {
        return $this->IsInactive;
    }
    /**
     * Set IsInactive value
     * @param bool $isInactive
     * @return \StructType\PvProductData_V2
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->IsInactive = $isInactive;
        return $this;
    }
    /**
     * Get AllowChangePrice value
     * @return bool
     */
    public function getAllowChangePrice()
    {
        return $this->AllowChangePrice;
    }
    /**
     * Set AllowChangePrice value
     * @param bool $allowChangePrice
     * @return \StructType\PvProductData_V2
     */
    public function setAllowChangePrice($allowChangePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChangePrice) && !is_bool($allowChangePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowChangePrice, true), gettype($allowChangePrice)), __LINE__);
        }
        $this->AllowChangePrice = $allowChangePrice;
        return $this;
    }
    /**
     * Get AllowChangeDescription value
     * @return bool
     */
    public function getAllowChangeDescription()
    {
        return $this->AllowChangeDescription;
    }
    /**
     * Set AllowChangeDescription value
     * @param bool $allowChangeDescription
     * @return \StructType\PvProductData_V2
     */
    public function setAllowChangeDescription($allowChangeDescription = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChangeDescription) && !is_bool($allowChangeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowChangeDescription, true), gettype($allowChangeDescription)), __LINE__);
        }
        $this->AllowChangeDescription = $allowChangeDescription;
        return $this;
    }
    /**
     * Get AllowChangeVat value
     * @return bool
     */
    public function getAllowChangeVat()
    {
        return $this->AllowChangeVat;
    }
    /**
     * Set AllowChangeVat value
     * @param bool $allowChangeVat
     * @return \StructType\PvProductData_V2
     */
    public function setAllowChangeVat($allowChangeVat = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChangeVat) && !is_bool($allowChangeVat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowChangeVat, true), gettype($allowChangeVat)), __LINE__);
        }
        $this->AllowChangeVat = $allowChangeVat;
        return $this;
    }
    /**
     * Get AutoEnableEdit value
     * @return bool
     */
    public function getAutoEnableEdit()
    {
        return $this->AutoEnableEdit;
    }
    /**
     * Set AutoEnableEdit value
     * @param bool $autoEnableEdit
     * @return \StructType\PvProductData_V2
     */
    public function setAutoEnableEdit($autoEnableEdit = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoEnableEdit) && !is_bool($autoEnableEdit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoEnableEdit, true), gettype($autoEnableEdit)), __LINE__);
        }
        $this->AutoEnableEdit = $autoEnableEdit;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\PvProductData_V2
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PvProductData_V2
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PvProductData_V2
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
