<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvNavigationItemData StructType
 * @subpackage Structs
 */
class PvNavigationItemData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Category;
    /**
     * The ViewEntryPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ViewEntryPoint;
    /**
     * The BaseEntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaseEntityType;
    /**
     * The RelationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RelationType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The SortIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortIndex;
    /**
     * Constructor method for PvNavigationItemData
     * @uses PvNavigationItemData::setId()
     * @uses PvNavigationItemData::setCategory()
     * @uses PvNavigationItemData::setViewEntryPoint()
     * @uses PvNavigationItemData::setBaseEntityType()
     * @uses PvNavigationItemData::setRelationType()
     * @uses PvNavigationItemData::setName()
     * @uses PvNavigationItemData::setSortIndex()
     * @param string $id
     * @param string $category
     * @param string $viewEntryPoint
     * @param string $baseEntityType
     * @param string $relationType
     * @param string $name
     * @param string $sortIndex
     */
    public function __construct($id = null, $category = null, $viewEntryPoint = null, $baseEntityType = null, $relationType = null, $name = null, $sortIndex = null)
    {
        $this
            ->setId($id)
            ->setCategory($category)
            ->setViewEntryPoint($viewEntryPoint)
            ->setBaseEntityType($baseEntityType)
            ->setRelationType($relationType)
            ->setName($name)
            ->setSortIndex($sortIndex);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvNavigationItemData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\NavigationItemCategory::valueIsValid()
     * @uses \EnumType\NavigationItemCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\PvNavigationItemData
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NavigationItemCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NavigationItemCategory', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \EnumType\NavigationItemCategory::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get ViewEntryPoint value
     * @return string
     */
    public function getViewEntryPoint()
    {
        return $this->ViewEntryPoint;
    }
    /**
     * Set ViewEntryPoint value
     * @uses \EnumType\ViewEntryPoint::valueIsValid()
     * @uses \EnumType\ViewEntryPoint::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viewEntryPoint
     * @return \StructType\PvNavigationItemData
     */
    public function setViewEntryPoint($viewEntryPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ViewEntryPoint::valueIsValid($viewEntryPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ViewEntryPoint', is_array($viewEntryPoint) ? implode(', ', $viewEntryPoint) : var_export($viewEntryPoint, true), implode(', ', \EnumType\ViewEntryPoint::getValidValues())), __LINE__);
        }
        $this->ViewEntryPoint = $viewEntryPoint;
        return $this;
    }
    /**
     * Get BaseEntityType value
     * @return string
     */
    public function getBaseEntityType()
    {
        return $this->BaseEntityType;
    }
    /**
     * Set BaseEntityType value
     * @uses \EnumType\BaseEntityType::valueIsValid()
     * @uses \EnumType\BaseEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseEntityType
     * @return \StructType\PvNavigationItemData
     */
    public function setBaseEntityType($baseEntityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BaseEntityType::valueIsValid($baseEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BaseEntityType', is_array($baseEntityType) ? implode(', ', $baseEntityType) : var_export($baseEntityType, true), implode(', ', \EnumType\BaseEntityType::getValidValues())), __LINE__);
        }
        $this->BaseEntityType = $baseEntityType;
        return $this;
    }
    /**
     * Get RelationType value
     * @return string
     */
    public function getRelationType()
    {
        return $this->RelationType;
    }
    /**
     * Set RelationType value
     * @uses \EnumType\RelationType::valueIsValid()
     * @uses \EnumType\RelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationType
     * @return \StructType\PvNavigationItemData
     */
    public function setRelationType($relationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RelationType::valueIsValid($relationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RelationType', is_array($relationType) ? implode(', ', $relationType) : var_export($relationType, true), implode(', ', \EnumType\RelationType::getValidValues())), __LINE__);
        }
        $this->RelationType = $relationType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PvNavigationItemData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SortIndex value
     * @return string|null
     */
    public function getSortIndex()
    {
        return $this->SortIndex;
    }
    /**
     * Set SortIndex value
     * @param string $sortIndex
     * @return \StructType\PvNavigationItemData
     */
    public function setSortIndex($sortIndex = null)
    {
        // validation for constraint: string
        if (!is_null($sortIndex) && !is_string($sortIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortIndex, true), gettype($sortIndex)), __LINE__);
        }
        $this->SortIndex = $sortIndex;
        return $this;
    }
}
