<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvFieldData StructType
 * @subpackage Structs
 */
class PvFieldData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The SortIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SortIndex;
    /**
     * The CategorySortIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategorySortIndex;
    /**
     * The HideAtEntryForm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HideAtEntryForm;
    /**
     * The IsReadOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReadOnly;
    /**
     * The Control
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Control;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Length;
    /**
     * The ComboboxValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ComboboxValues;
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRequired;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryName;
    /**
     * The UserFriendlyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserFriendlyName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraInfo;
    /**
     * Constructor method for PvFieldData
     * @uses PvFieldData::setId()
     * @uses PvFieldData::setSortIndex()
     * @uses PvFieldData::setCategorySortIndex()
     * @uses PvFieldData::setHideAtEntryForm()
     * @uses PvFieldData::setIsReadOnly()
     * @uses PvFieldData::setControl()
     * @uses PvFieldData::setType()
     * @uses PvFieldData::setLength()
     * @uses PvFieldData::setComboboxValues()
     * @uses PvFieldData::setIsRequired()
     * @uses PvFieldData::setLabel()
     * @uses PvFieldData::setName()
     * @uses PvFieldData::setCategoryName()
     * @uses PvFieldData::setUserFriendlyName()
     * @uses PvFieldData::setDescription()
     * @uses PvFieldData::setExtraInfo()
     * @param string $id
     * @param int $sortIndex
     * @param int $categorySortIndex
     * @param bool $hideAtEntryForm
     * @param bool $isReadOnly
     * @param string $control
     * @param string $type
     * @param int $length
     * @param string $comboboxValues
     * @param bool $isRequired
     * @param string $label
     * @param string $name
     * @param string $categoryName
     * @param string $userFriendlyName
     * @param string $description
     * @param string $extraInfo
     */
    public function __construct($id = null, $sortIndex = null, $categorySortIndex = null, $hideAtEntryForm = null, $isReadOnly = null, $control = null, $type = null, $length = null, $comboboxValues = null, $isRequired = null, $label = null, $name = null, $categoryName = null, $userFriendlyName = null, $description = null, $extraInfo = null)
    {
        $this
            ->setId($id)
            ->setSortIndex($sortIndex)
            ->setCategorySortIndex($categorySortIndex)
            ->setHideAtEntryForm($hideAtEntryForm)
            ->setIsReadOnly($isReadOnly)
            ->setControl($control)
            ->setType($type)
            ->setLength($length)
            ->setComboboxValues($comboboxValues)
            ->setIsRequired($isRequired)
            ->setLabel($label)
            ->setName($name)
            ->setCategoryName($categoryName)
            ->setUserFriendlyName($userFriendlyName)
            ->setDescription($description)
            ->setExtraInfo($extraInfo);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvFieldData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get SortIndex value
     * @return int
     */
    public function getSortIndex()
    {
        return $this->SortIndex;
    }
    /**
     * Set SortIndex value
     * @param int $sortIndex
     * @return \StructType\PvFieldData
     */
    public function setSortIndex($sortIndex = null)
    {
        // validation for constraint: int
        if (!is_null($sortIndex) && !(is_int($sortIndex) || ctype_digit($sortIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sortIndex, true), gettype($sortIndex)), __LINE__);
        }
        $this->SortIndex = $sortIndex;
        return $this;
    }
    /**
     * Get CategorySortIndex value
     * @return int
     */
    public function getCategorySortIndex()
    {
        return $this->CategorySortIndex;
    }
    /**
     * Set CategorySortIndex value
     * @param int $categorySortIndex
     * @return \StructType\PvFieldData
     */
    public function setCategorySortIndex($categorySortIndex = null)
    {
        // validation for constraint: int
        if (!is_null($categorySortIndex) && !(is_int($categorySortIndex) || ctype_digit($categorySortIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categorySortIndex, true), gettype($categorySortIndex)), __LINE__);
        }
        $this->CategorySortIndex = $categorySortIndex;
        return $this;
    }
    /**
     * Get HideAtEntryForm value
     * @return bool
     */
    public function getHideAtEntryForm()
    {
        return $this->HideAtEntryForm;
    }
    /**
     * Set HideAtEntryForm value
     * @param bool $hideAtEntryForm
     * @return \StructType\PvFieldData
     */
    public function setHideAtEntryForm($hideAtEntryForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideAtEntryForm) && !is_bool($hideAtEntryForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideAtEntryForm, true), gettype($hideAtEntryForm)), __LINE__);
        }
        $this->HideAtEntryForm = $hideAtEntryForm;
        return $this;
    }
    /**
     * Get IsReadOnly value
     * @return bool
     */
    public function getIsReadOnly()
    {
        return $this->IsReadOnly;
    }
    /**
     * Set IsReadOnly value
     * @param bool $isReadOnly
     * @return \StructType\PvFieldData
     */
    public function setIsReadOnly($isReadOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadOnly) && !is_bool($isReadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadOnly, true), gettype($isReadOnly)), __LINE__);
        }
        $this->IsReadOnly = $isReadOnly;
        return $this;
    }
    /**
     * Get Control value
     * @return string
     */
    public function getControl()
    {
        return $this->Control;
    }
    /**
     * Set Control value
     * @uses \EnumType\DesignerControlType::valueIsValid()
     * @uses \EnumType\DesignerControlType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $control
     * @return \StructType\PvFieldData
     */
    public function setControl($control = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DesignerControlType::valueIsValid($control)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DesignerControlType', is_array($control) ? implode(', ', $control) : var_export($control, true), implode(', ', \EnumType\DesignerControlType::getValidValues())), __LINE__);
        }
        $this->Control = $control;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\DatabaseFieldType::valueIsValid()
     * @uses \EnumType\DatabaseFieldType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PvFieldData
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatabaseFieldType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DatabaseFieldType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\DatabaseFieldType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Length value
     * @return int
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \StructType\PvFieldData
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get ComboboxValues value
     * @return string
     */
    public function getComboboxValues()
    {
        return $this->ComboboxValues;
    }
    /**
     * Set ComboboxValues value
     * @uses \EnumType\ComboboxValuesType::valueIsValid()
     * @uses \EnumType\ComboboxValuesType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comboboxValues
     * @return \StructType\PvFieldData
     */
    public function setComboboxValues($comboboxValues = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComboboxValuesType::valueIsValid($comboboxValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ComboboxValuesType', is_array($comboboxValues) ? implode(', ', $comboboxValues) : var_export($comboboxValues, true), implode(', ', \EnumType\ComboboxValuesType::getValidValues())), __LINE__);
        }
        $this->ComboboxValues = $comboboxValues;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return bool
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \StructType\PvFieldData
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \StructType\PvFieldData
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PvFieldData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\PvFieldData
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get UserFriendlyName value
     * @return string|null
     */
    public function getUserFriendlyName()
    {
        return $this->UserFriendlyName;
    }
    /**
     * Set UserFriendlyName value
     * @param string $userFriendlyName
     * @return \StructType\PvFieldData
     */
    public function setUserFriendlyName($userFriendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($userFriendlyName) && !is_string($userFriendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userFriendlyName, true), gettype($userFriendlyName)), __LINE__);
        }
        $this->UserFriendlyName = $userFriendlyName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PvFieldData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ExtraInfo value
     * @return string|null
     */
    public function getExtraInfo()
    {
        return $this->ExtraInfo;
    }
    /**
     * Set ExtraInfo value
     * @param string $extraInfo
     * @return \StructType\PvFieldData
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        $this->ExtraInfo = $extraInfo;
        return $this;
    }
}
