<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvCounterData StructType
 * @subpackage Structs
 */
class PvCounterData extends AbstractStructBase
{
    /**
     * The TabPageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TabPageType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Value;
    /**
     * Constructor method for PvCounterData
     * @uses PvCounterData::setTabPageType()
     * @uses PvCounterData::setValue()
     * @param string $tabPageType
     * @param int $value
     */
    public function __construct($tabPageType = null, $value = null)
    {
        $this
            ->setTabPageType($tabPageType)
            ->setValue($value);
    }
    /**
     * Get TabPageType value
     * @return string
     */
    public function getTabPageType()
    {
        return $this->TabPageType;
    }
    /**
     * Set TabPageType value
     * @uses \EnumType\TabPageType::valueIsValid()
     * @uses \EnumType\TabPageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tabPageType
     * @return \StructType\PvCounterData
     */
    public function setTabPageType($tabPageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TabPageType::valueIsValid($tabPageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TabPageType', is_array($tabPageType) ? implode(', ', $tabPageType) : var_export($tabPageType, true), implode(', ', \EnumType\TabPageType::getValidValues())), __LINE__);
        }
        $this->TabPageType = $tabPageType;
        return $this;
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \StructType\PvCounterData
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
