<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvAuditData StructType
 * @subpackage Structs
 */
class PvAuditData extends AbstractStructBase
{
    /**
     * The CreatedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreatedAt;
    /**
     * The CreatedByUser
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $CreatedByUser;
    /**
     * The ModifiedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModifiedAt;
    /**
     * The ModifiedByUser
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ModifiedByUser;
    /**
     * Constructor method for PvAuditData
     * @uses PvAuditData::setCreatedAt()
     * @uses PvAuditData::setCreatedByUser()
     * @uses PvAuditData::setModifiedAt()
     * @uses PvAuditData::setModifiedByUser()
     * @param string $createdAt
     * @param string $createdByUser
     * @param string $modifiedAt
     * @param string $modifiedByUser
     */
    public function __construct($createdAt = null, $createdByUser = null, $modifiedAt = null, $modifiedByUser = null)
    {
        $this
            ->setCreatedAt($createdAt)
            ->setCreatedByUser($createdByUser)
            ->setModifiedAt($modifiedAt)
            ->setModifiedByUser($modifiedByUser);
    }
    /**
     * Get CreatedAt value
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->CreatedAt;
    }
    /**
     * Set CreatedAt value
     * @param string $createdAt
     * @return \StructType\PvAuditData
     */
    public function setCreatedAt($createdAt = null)
    {
        // validation for constraint: string
        if (!is_null($createdAt) && !is_string($createdAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAt, true), gettype($createdAt)), __LINE__);
        }
        $this->CreatedAt = $createdAt;
        return $this;
    }
    /**
     * Get CreatedByUser value
     * @return string
     */
    public function getCreatedByUser()
    {
        return $this->CreatedByUser;
    }
    /**
     * Set CreatedByUser value
     * @param string $createdByUser
     * @return \StructType\PvAuditData
     */
    public function setCreatedByUser($createdByUser = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUser) && !is_string($createdByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByUser, true), gettype($createdByUser)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($createdByUser) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $createdByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($createdByUser, true)), __LINE__);
        }
        $this->CreatedByUser = $createdByUser;
        return $this;
    }
    /**
     * Get ModifiedAt value
     * @return string
     */
    public function getModifiedAt()
    {
        return $this->ModifiedAt;
    }
    /**
     * Set ModifiedAt value
     * @param string $modifiedAt
     * @return \StructType\PvAuditData
     */
    public function setModifiedAt($modifiedAt = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedAt) && !is_string($modifiedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedAt, true), gettype($modifiedAt)), __LINE__);
        }
        $this->ModifiedAt = $modifiedAt;
        return $this;
    }
    /**
     * Get ModifiedByUser value
     * @return string
     */
    public function getModifiedByUser()
    {
        return $this->ModifiedByUser;
    }
    /**
     * Set ModifiedByUser value
     * @param string $modifiedByUser
     * @return \StructType\PvAuditData
     */
    public function setModifiedByUser($modifiedByUser = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedByUser) && !is_string($modifiedByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedByUser, true), gettype($modifiedByUser)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($modifiedByUser) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $modifiedByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($modifiedByUser, true)), __LINE__);
        }
        $this->ModifiedByUser = $modifiedByUser;
        return $this;
    }
}
