<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvAttachmentData StructType
 * @subpackage Structs
 */
class PvAttachmentData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The ExternalDmsType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ExternalDmsType;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Version;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Extension;
    /**
     * The ExternalDmsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalDmsId;
    /**
     * The Base64EncodedFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Base64EncodedFile;
    /**
     * Constructor method for PvAttachmentData
     * @uses PvAttachmentData::setId()
     * @uses PvAttachmentData::setCreationDate()
     * @uses PvAttachmentData::setModificationDate()
     * @uses PvAttachmentData::setExternalDmsType()
     * @uses PvAttachmentData::setFileName()
     * @uses PvAttachmentData::setDescription()
     * @uses PvAttachmentData::setVersion()
     * @uses PvAttachmentData::setExtension()
     * @uses PvAttachmentData::setExternalDmsId()
     * @uses PvAttachmentData::setBase64EncodedFile()
     * @param string $id
     * @param string $creationDate
     * @param string $modificationDate
     * @param int $externalDmsType
     * @param string $fileName
     * @param string $description
     * @param string $version
     * @param string $extension
     * @param string $externalDmsId
     * @param string $base64EncodedFile
     */
    public function __construct($id = null, $creationDate = null, $modificationDate = null, $externalDmsType = null, $fileName = null, $description = null, $version = null, $extension = null, $externalDmsId = null, $base64EncodedFile = null)
    {
        $this
            ->setId($id)
            ->setCreationDate($creationDate)
            ->setModificationDate($modificationDate)
            ->setExternalDmsType($externalDmsType)
            ->setFileName($fileName)
            ->setDescription($description)
            ->setVersion($version)
            ->setExtension($extension)
            ->setExternalDmsId($externalDmsId)
            ->setBase64EncodedFile($base64EncodedFile);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvAttachmentData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\PvAttachmentData
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\PvAttachmentData
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get ExternalDmsType value
     * @return int
     */
    public function getExternalDmsType()
    {
        return $this->ExternalDmsType;
    }
    /**
     * Set ExternalDmsType value
     * @param int $externalDmsType
     * @return \StructType\PvAttachmentData
     */
    public function setExternalDmsType($externalDmsType = null)
    {
        // validation for constraint: int
        if (!is_null($externalDmsType) && !(is_int($externalDmsType) || ctype_digit($externalDmsType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalDmsType, true), gettype($externalDmsType)), __LINE__);
        }
        $this->ExternalDmsType = $externalDmsType;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\PvAttachmentData
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PvAttachmentData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\PvAttachmentData
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \StructType\PvAttachmentData
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get ExternalDmsId value
     * @return string|null
     */
    public function getExternalDmsId()
    {
        return $this->ExternalDmsId;
    }
    /**
     * Set ExternalDmsId value
     * @param string $externalDmsId
     * @return \StructType\PvAttachmentData
     */
    public function setExternalDmsId($externalDmsId = null)
    {
        // validation for constraint: string
        if (!is_null($externalDmsId) && !is_string($externalDmsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDmsId, true), gettype($externalDmsId)), __LINE__);
        }
        $this->ExternalDmsId = $externalDmsId;
        return $this;
    }
    /**
     * Get Base64EncodedFile value
     * @return string|null
     */
    public function getBase64EncodedFile()
    {
        return $this->Base64EncodedFile;
    }
    /**
     * Set Base64EncodedFile value
     * @param string $base64EncodedFile
     * @return \StructType\PvAttachmentData
     */
    public function setBase64EncodedFile($base64EncodedFile = null)
    {
        // validation for constraint: string
        if (!is_null($base64EncodedFile) && !is_string($base64EncodedFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64EncodedFile, true), gettype($base64EncodedFile)), __LINE__);
        }
        $this->Base64EncodedFile = $base64EncodedFile;
        return $this;
    }
}
