<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvActivitySettingsData StructType
 * @subpackage Structs
 */
class PvActivitySettingsData extends AbstractStructBase
{
    /**
     * The WorkflowId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $WorkflowId;
    /**
     * The WorkflowStepId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $WorkflowStepId;
    /**
     * The ParentRelationshipId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ParentRelationshipId;
    /**
     * The ChildRelationshipId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ChildRelationshipId;
    /**
     * Constructor method for PvActivitySettingsData
     * @uses PvActivitySettingsData::setWorkflowId()
     * @uses PvActivitySettingsData::setWorkflowStepId()
     * @uses PvActivitySettingsData::setParentRelationshipId()
     * @uses PvActivitySettingsData::setChildRelationshipId()
     * @param string $workflowId
     * @param string $workflowStepId
     * @param string $parentRelationshipId
     * @param string $childRelationshipId
     */
    public function __construct($workflowId = null, $workflowStepId = null, $parentRelationshipId = null, $childRelationshipId = null)
    {
        $this
            ->setWorkflowId($workflowId)
            ->setWorkflowStepId($workflowStepId)
            ->setParentRelationshipId($parentRelationshipId)
            ->setChildRelationshipId($childRelationshipId);
    }
    /**
     * Get WorkflowId value
     * @return string
     */
    public function getWorkflowId()
    {
        return $this->WorkflowId;
    }
    /**
     * Set WorkflowId value
     * @param string $workflowId
     * @return \StructType\PvActivitySettingsData
     */
    public function setWorkflowId($workflowId = null)
    {
        // validation for constraint: string
        if (!is_null($workflowId) && !is_string($workflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowId, true), gettype($workflowId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($workflowId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $workflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($workflowId, true)), __LINE__);
        }
        $this->WorkflowId = $workflowId;
        return $this;
    }
    /**
     * Get WorkflowStepId value
     * @return string
     */
    public function getWorkflowStepId()
    {
        return $this->WorkflowStepId;
    }
    /**
     * Set WorkflowStepId value
     * @param string $workflowStepId
     * @return \StructType\PvActivitySettingsData
     */
    public function setWorkflowStepId($workflowStepId = null)
    {
        // validation for constraint: string
        if (!is_null($workflowStepId) && !is_string($workflowStepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowStepId, true), gettype($workflowStepId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($workflowStepId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $workflowStepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($workflowStepId, true)), __LINE__);
        }
        $this->WorkflowStepId = $workflowStepId;
        return $this;
    }
    /**
     * Get ParentRelationshipId value
     * @return string
     */
    public function getParentRelationshipId()
    {
        return $this->ParentRelationshipId;
    }
    /**
     * Set ParentRelationshipId value
     * @param string $parentRelationshipId
     * @return \StructType\PvActivitySettingsData
     */
    public function setParentRelationshipId($parentRelationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($parentRelationshipId) && !is_string($parentRelationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentRelationshipId, true), gettype($parentRelationshipId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($parentRelationshipId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $parentRelationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($parentRelationshipId, true)), __LINE__);
        }
        $this->ParentRelationshipId = $parentRelationshipId;
        return $this;
    }
    /**
     * Get ChildRelationshipId value
     * @return string
     */
    public function getChildRelationshipId()
    {
        return $this->ChildRelationshipId;
    }
    /**
     * Set ChildRelationshipId value
     * @param string $childRelationshipId
     * @return \StructType\PvActivitySettingsData
     */
    public function setChildRelationshipId($childRelationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($childRelationshipId) && !is_string($childRelationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childRelationshipId, true), gettype($childRelationshipId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($childRelationshipId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $childRelationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($childRelationshipId, true)), __LINE__);
        }
        $this->ChildRelationshipId = $childRelationshipId;
        return $this;
    }
}
