<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvActivityAuditData StructType
 * @subpackage Structs
 */
class PvActivityAuditData extends AbstractStructBase
{
    /**
     * The ClosedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ClosedAt;
    /**
     * The ClosedByUser
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ClosedByUser;
    /**
     * Constructor method for PvActivityAuditData
     * @uses PvActivityAuditData::setClosedAt()
     * @uses PvActivityAuditData::setClosedByUser()
     * @param string $closedAt
     * @param string $closedByUser
     */
    public function __construct($closedAt = null, $closedByUser = null)
    {
        $this
            ->setClosedAt($closedAt)
            ->setClosedByUser($closedByUser);
    }
    /**
     * Get ClosedAt value
     * @return string
     */
    public function getClosedAt()
    {
        return $this->ClosedAt;
    }
    /**
     * Set ClosedAt value
     * @param string $closedAt
     * @return \StructType\PvActivityAuditData
     */
    public function setClosedAt($closedAt = null)
    {
        // validation for constraint: string
        if (!is_null($closedAt) && !is_string($closedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closedAt, true), gettype($closedAt)), __LINE__);
        }
        $this->ClosedAt = $closedAt;
        return $this;
    }
    /**
     * Get ClosedByUser value
     * @return string
     */
    public function getClosedByUser()
    {
        return $this->ClosedByUser;
    }
    /**
     * Set ClosedByUser value
     * @param string $closedByUser
     * @return \StructType\PvActivityAuditData
     */
    public function setClosedByUser($closedByUser = null)
    {
        // validation for constraint: string
        if (!is_null($closedByUser) && !is_string($closedByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closedByUser, true), gettype($closedByUser)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($closedByUser) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $closedByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($closedByUser, true)), __LINE__);
        }
        $this->ClosedByUser = $closedByUser;
        return $this;
    }
}
