<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCreate_V2 StructType
 * @subpackage Structs
 */
class ProductCreate_V2 extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The productData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvProductData_V2
     */
    public $productData;
    /**
     * Constructor method for ProductCreate_V2
     * @uses ProductCreate_V2::setCredentials()
     * @uses ProductCreate_V2::setProductData()
     * @param \StructType\ApiCredentials $credentials
     * @param \StructType\PvProductData_V2 $productData
     */
    public function __construct(\StructType\ApiCredentials $credentials = null, \StructType\PvProductData_V2 $productData = null)
    {
        $this
            ->setCredentials($credentials)
            ->setProductData($productData);
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ProductCreate_V2
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get productData value
     * @return \StructType\PvProductData_V2|null
     */
    public function getProductData()
    {
        return $this->productData;
    }
    /**
     * Set productData value
     * @param \StructType\PvProductData_V2 $productData
     * @return \StructType\ProductCreate_V2
     */
    public function setProductData(\StructType\PvProductData_V2 $productData = null)
    {
        $this->productData = $productData;
        return $this;
    }
}
